!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   UndefinedObject, Object.
!
!=========================================================================

removeallmethods UndefinedObject
removeallclassmethods UndefinedObject 

category: 'For Documentation Installation only'
classmethod: UndefinedObject
installDocumentation

self comment:
'This class describes the behavior of nil, the `nonexistent'' object.  You may
 not create new instances of UndefinedObject.'.
%

category: 'Instance Creation'
classmethod: UndefinedObject
fromStream: aStream

"If the next Characters in aStream are nil (case-insensitive), returns nil.
 Otherwise, generates an error."

| ch |

self _checkReadStream: aStream forClass: CharacterCollection.

ch := aStream next.
[ ch == $  ]
whileTrue:
  [ ch := aStream next ].
aStream skip: -1.

(((aStream next isEquivalent: $N)
 and: [aStream next isEquivalent: $I ])
 and: [aStream next isEquivalent: $L ])
ifTrue:
  [ ^ nil ]
ifFalse:
  [ self _errIncorrectFormat: aStream ]
%

category: 'Instance Creation'
classmethod: UndefinedObject
fromString: aString

"If the first three Characters in aString are nil (case-insensitive), returns
 nil.  Otherwise, generates an error."

| s result |

s := ReadStream on: aString.
result := self fromStream: s.
[ s atEnd ]
whileFalse:
  [ (s next == $  )
    ifFalse:
      [ self _errIncorrectFormat: aString ]
  ].
^ result
%

category: 'Instance Creation'
classmethod: UndefinedObject
new

"Disallowed.  You cannot create new instances of UndefinedObject."

self shouldNotImplement: #new
%

category: 'Storing and Loading'
classmethod: UndefinedObject
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

"This method supports activation of passive objects written by a GeODE
 version earlier than 2.0.1."

passiveObj hasRead: nil.
^nil
%

category: 'Formatting'
method: UndefinedObject
asString

"Returns the string 'nil'."

self == nil ifTrue:[ ^ String withAll:'nil' ].
"#_remoteNil  is a key in Globals"
self == _remoteNil ifTrue:[ ^ String withAll:'remoteNil' ].

"following are normally only seen by stack printing code in GsProcess.
 and are defined as class variables in UndefinedObject."
self == _exceptionMarkNil ifTrue:[ ^ String withAll:'_exceptionMarkNil' ].
self == _gsExcHandlerMarkNil ifTrue:[ ^ String withAll:'_gsExcHandlerMarkNil' ].
self == _ensureMarkNil ifTrue:[ ^ String withAll:'_ensureMarkNil' ].
self == _rfhMarkNil ifTrue:[ ^ String withAll:'_rfhMarkNil' ].
self == _rfhGsExcHandlerMarkNil ifTrue:[ ^ String withAll:'_rfhGsExcHandlerMarkNil' ].
self == _tosIsIpNil ifTrue:[ ^ String withAll:'_tosIsIpNil' ].
self == _noResultNil ifTrue:[ ^ String withAll:'_noResultNil' ].
self == _executeHandlerMarkNil ifTrue:[ ^ String withAll:'_executeHandlerMarkNil' ].
self == _reenterMarkNil ifTrue:[ ^ String withAll:'_reenterMarkNil' ].
self == _rubyNoArgNil ifTrue:[ ^ String withAll:'_rubyNoArgNil' ].
self == _syncExceptionMarkNil ifTrue:[ ^ String withAll:'_syncExceptionMarkNil'].

  "following instances should not be visible to application code
   unless an internal error occurs during VM execution."
self == _rubyEvalRfhMarkNil ifTrue:[ ^ String withAll:'_rubyEvalRfhMarkNil'].
self == _rubyRExecHandlerMarkNil ifTrue:[ ^ String withAll:'_rubyRExecHandlerMarkNil'].
self == _rubyFrameLocalsNil ifTrue:[ ^ String withAll:'_rubyFrameLocalsNil' ].
self == _partialContinuaLoadMarkNil ifTrue:[ ^ String withAll:'_partialContinuaLoadMarkNil' ].
^ 'unrecognized instance of UndefinedObject, oop ' , self asOop asString .
%

category: 'Formatting'
method: UndefinedObject
describe
 "when printing stack reports avoid putting an exception handler on the 
  stack for printing a nil."
^ self asString
%
category: 'Formatting'
method: UndefinedObject
printString
 "when printing stack reports avoid putting an exception handler on the 
  stack for printing a nil."
^ self asString
%

category: 'Clustering'
method: UndefinedObject
clusterDepthFirst

"Returns true.  (Because nil is a self-defining object, this method has no
 effect.)"

^ true
%

category: 'Copying'
method: UndefinedObject
copy

"Returns the receiver.  The pseudovariable nil is the only instance of
 UndefinedObject, and must preserve identity."

^self
%

category: 'Formatting'
method: UndefinedObject
describeClassName

"Returns a String to describe classes with nil names."

^ 'unnamed'
%

! deleted _idxCompareLessThan:v2.0

! deleted _idxCompareLessThanOrEqual: v2.0

! deleted _idxCompareGreaterThan: v2.0

! deleted _idxCompareGreaterThanOrEqual: v2.0

! deleted _isNaN v2.0

category: 'Decompiling without Sources'
method: UndefinedObject
_asSource

""

^ self asString
%

category: 'Indexing Support'
method: UndefinedObject
getDepListAndAddPathTerm: pathTerm withIVOffset: ivOffset logging: aBoolean

"Private."

^ self
%

category: 'Storing and Loading'
method: UndefinedObject
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

| c |
self == _remoteNil ifTrue:[ c := $# ] ifFalse:[ c := $. ].
passiveObj nextPut: c
%

category: 'Filein Support'
method: UndefinedObject
_newKernelSubclass: clsName
instVarNames: ivArg
classVars: classVarArg
classInstVars: classInstVarArg
poolDictionaries: poolDicts
inDictionary: aDict
options: options
reservedOop: reservedOopNum

"Creates a new class only if a class with the given name does not already exist
 in Globals.  Returns a String, either the definition of the new class or a
 message that the class already exists."

| result theClass superClassOffset |

result := Object
  _newKernelSubclass: clsName
  subclassOf: self
  instVarNames: ivArg
  classVars: classVarArg
  classInstVars: classInstVarArg
  poolDictionaries: poolDicts
  inDictionary: aDict
  options: options
  reservedOop: reservedOopNum .

(result at:1 equals:'class already exists') ifTrue:[ ^ result ].

"now fixup the superclass info to be nil"
theClass := Globals at: clsName asSymbol .
superClassOffset := (Behavior _ivOffsetOf: #superClass) .
theClass _unsafeAt: superClassOffset       put: nil .
theClass class _unsafeAt: superClassOffset put: Object class superClass  .
^ result , ' , final definition: ' , theClass definition .
%

category 'Deprecated'
method: UndefinedObject
subclass: aString
instVarNames: anArrayOfStrings
inDictionary: aDictionary
constraints: constraintSpec

"Private.  Creates and returns a new subclass of the receiver.
 For further documentation see the same selector in Class."

self deprecated: 'UndefinedObject>>subclass:instVarNames:inDictionary:constraints: deprecated before v3.0; constraints no longer supported'.
^ self subclass: aString
    instVarNames: anArrayOfStrings
    classVars: #()
    classInstVars: #()
    poolDictionaries: #()
    inDictionary: aDictionary
    constraints: constraintSpec
    instancesInvariant: false
    isModifiable: false
%

! fixed 11833
category 'Deprecated'
method: UndefinedObject
subclass: aString
instVarNames: anArrayOfStrings
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
isModifiable: modifyBoolean

	"Private.  Creates and returns a new subclass of the receiver.

 For further documentation see the same selector in Class."

	| theClass superClassOffset oldClass opts |
	self
		deprecated: 'UndefinedObject>>subclass:instVarNames:classVars:...constraints:... deprecated before v3.0; constraints no longer supported'.
	oldClass := Object _classNamed: aString inDictionary: aDictionary.
	opts := {}.
	invarBoolean
		ifTrue: [opts add: #instancesInvariant]
		ifFalse: 
			[Object instancesInvariant
				ifTrue: [^self _error: #classErrInvariantSuperClass]].
	modifyBoolean ifTrue: [opts add: #modifiable].
	oldClass
		ifNotNil: 
			[(Object
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: opts
				newFormat: oldClass format
				newInstVars: anArrayOfStrings
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false) ifTrue: [^oldClass	"avoid creation of a new version"]].
	theClass := Object
				subclass: aString
				instVarNames: anArrayOfStrings
				classVars: anArrayOfClassVars
				classInstVars: anArrayOfClassInstVars
				poolDictionaries: anArrayOfPoolDicts
				inDictionary: aDictionary
				constraints: aConstraint
				instancesInvariant: invarBoolean
				isModifiable: modifyBoolean.
	superClassOffset := Behavior _ivOffsetOf: #superClass.
	theClass _unsafeAt: superClassOffset put: nil.
	theClass class _unsafeAt: superClassOffset put: Object class superClass.
	^theClass
%

! fixed 11833
category: 'Subclass Creation'
method: UndefinedObject
subclass: aString 
instVarNames: anArrayOfInstvarNames 
classVars: anArrayOfClassVars 
classInstVars: anArrayOfClassInstVars 
poolDictionaries: anArrayOfPoolDicts 
inDictionary: aDictionary 
newVersionOf: oldClass 
description: aDescription 
options: optionsArray

  | descr theClass superClassOffset |
  descr := aDescription.
  oldClass ifNotNil: [ 
     (Object _equivalentSubclass: oldClass
        superCls: self
        name: aString
        newOpts: optionsArray
        newFormat: oldClass format
        newInstVars: anArrayOfInstvarNames
        newClassInstVars: anArrayOfClassInstVars
        newPools: anArrayOfPoolDicts
        newClassVars: anArrayOfClassVars
        inDict: aDictionary
        isKernel: false ) ifTrue: [
            oldClass _commentOrDescription: aDescription.
            ^oldClass "avoid creation of a new version"
        ].
      descr ifNil:[ descr := [ oldClass comment ] on: Error do:[:ex | 'old comment not available']]
  ].
  theClass := Object
        subclass: aString
        instVarNames: anArrayOfInstvarNames
        classVars: anArrayOfClassVars
        classInstVars: anArrayOfClassInstVars
        poolDictionaries: anArrayOfPoolDicts
        inDictionary: aDictionary
        newVersionOf: oldClass
        description: descr
        options: optionsArray.
  theClass == oldClass
    ifFalse:
      [superClassOffset := Behavior _ivOffsetOf: #superClass.
      theClass _unsafeAt: superClassOffset put: nil.
      theClass class _unsafeAt: superClassOffset put: Object class superClass].
  ^theClass
%

category: 'Storing and Loading'
method: UndefinedObject
containsIdentity

"Private."

^true
%
category: 'Testing'
method: UndefinedObject
isSpecial

"Returns true if the receiver is a special object."

^ true
%

category: 'New Indexing Comparison'
method: UndefinedObject
_classSortOrdinal

^ 0
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareGreaterThan: arg

""

^arg _idxForCompareUndefinedObjectGreaterThanSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareGreaterThanOrEqualTo: arg

""

^arg _idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareLessThan: arg

""

^arg _idxForCompareUndefinedObjectLessThanSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareLessThanOrEqualTo: arg

""

^arg _idxForCompareUndefinedObjectLessThanOrEqualToSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortGreaterThan: arg

""

^arg _idxForSortUndefinedObjectGreaterThanSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortGreaterThanOrEqualTo: arg

""

^arg _idxForSortUndefinedObjectGreaterThanOrEqualToSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortLessThan: arg

""

^arg _idxForSortUndefinedObjectLessThanSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortLessThanOrEqualTo: arg

""

^arg _idxForSortUndefinedObjectLessThanOrEqualToSelf: self
%
category: 'New Indexing Comparison - for Sort'
method: UndefinedObject
_idxForSortUndefinedObjectLessThanOrEqualToSelf: anUndefinedObject

"second half of a double dispatch call from UndefinedObject>>_idxForSortLessThanOrEqualTo:. Note that anUndefinedObject should be the receiver in any <= comparison"

^true
%
category: 'New Indexing Comparison - for Sort'
method: UndefinedObject
_idxForSortUndefinedObjectGreaterThanOrEqualToSelf: anObject

"second half of a double dispatch call from UndefinedObject>>_idxForSortGreaterThanOrEqualTo:. Note that anUndefinedObject should be the receiver in any >= comparison"

^true
%
category: 'New Indexing Comparison - for Sort'
method: UndefinedObject
_idxForSortUndefinedObjectLessThanSelf: anObject

"second half of a double dispatch call from UndefinedObject>>_idxForSortLessThan:. Note that anUndefinedObject should be the receiver in any < comparison"

^false
%
category: 'New Indexing Comparison - for Sort'
method: UndefinedObject
_idxForSortUndefinedObjectGreaterThanSelf: anUndefinedObject

"second half of a double dispatch call from UndefinedObject>>_idxForSortGreaterThan:. Note that anUndefinedObject should be the receiver in any > comparison"

^false
%
category: 'New Indexing Comparison - for Compare'
method: UndefinedObject
_idxForCompareUndefinedObjectGreaterThanSelf: anUndefinedObject

"second half of a double dispatch call from UndefinedObject>>_idxForCompareGreaterThan:."

^false
%
category: 'New Indexing Comparison - for Compare'
method: UndefinedObject
_idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: anUndefinedObject

"second half of a double dispatch call from UndefinedObject>>_idxForCompareGreaterThanOrEqualTo:."

^true
%
category: 'New Indexing Comparison - for Compare'
method: UndefinedObject
_idxForCompareUndefinedObjectLessThanOrEqualToSelf: anUndefinedObject

"second half of a double dispatch call from UndefinedObject>>_idxForCompareLessThanOrEqualTo:."

^true
%
category: 'New Indexing Comparison - for Compare'
method: UndefinedObject
_idxForCompareUndefinedObjectLessThanSelf: anUndefinedObject

"second half of a double dispatch call from UndefinedObject>>_idxForCompareLessThan:."

^false
%
category: 'Json'
method: UndefinedObject
printJsonOn: aStream

	aStream nextPutAll: 'null'.
%

category: 'New Indexing Comparison'
set compile_env: 0
method: UndefinedObject
_idxForCompareEqualTo: aCharacterCollection collator: collator
  ""

  ^ self _idxForCompareEqualTo: aCharacterCollection
%
category: 'New Indexing Comparison'
set compile_env: 0
method: UndefinedObject
_idxForCompareGreaterThan: aCharacterCollection collator: collator
  ""

  ^ self _idxForCompareGreaterThan: aCharacterCollection
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareGreaterThanUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThan:collator:. Note that aUnicodeString should be the receiver in any > comparison"

  ^ self _idxForCompareGreaterThan: aUnicodeString
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareGreaterThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any >= comparison"

  ^ self _idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: aUnicodeString
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareLessThanUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThan:collator:. Note that aUnicodeString should be the receiver in any < comparison"

  ^ self _idxForCompareLessThan: aUnicodeString
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareLessThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any <= comparison"

  ^ self _idxForCompareLessThanOrEqualTo: aUnicodeString
%
category: 'New Indexing Comparison'
set compile_env: 0
method: UndefinedObject
_idxForSortLessThan: aCharacterCollection collator: collator
  ""

  ^ self _idxForSortLessThan: aCharacterCollection
%
category: 'New Indexing Comparison'
set compile_env: 0
method: UndefinedObject
_idxForSortLessThanOrEqualTo: aCharacterCollection collator: collator
  ""

  ^ self _idxForSortLessThanOrEqualTo: aCharacterCollection
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortEqualTo: aCharacterCollection collator: collator
  ""

  ^ self _idxForSortEqualTo: aCharacterCollection
%
