!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcQueueSessionComponent, Array, SequenceableCollection, Collection, Object.
!
!=========================================================================

expectvalue %String
run
  ^ Array _newKernelSubclass: 'RcQueueSessionComponent'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: { }
    inDictionary: Globals
    options: #()
    reservedOop: 853 .
%

removeallmethods RcQueueSessionComponent
removeallclassmethods RcQueueSessionComponent

category: 'For Documentation Installation only'
classmethod: RcQueueSessionComponent
installDocumentation

self comment:
'An RcQueueSessionComponent is the unit within a reduced-conflict queue that
holds all of the queue entries submitted by a given session.  A new RcQueue
allows the same number of sessions as the GemStone system''s maximum number of
sessions.  You can modify this number using the changeMaxSessionId: method.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	[elements]: RcQueueElement'.
%

category: 'Constants'
classmethod: RcQueueSessionComponent
speciesOfElements

^RcQueueEntry
%

category: 'Copying'
method: RcQueueSessionComponent
postCopy

super postCopy.
1 to: self _basicSize do:[:n| self _at: n put: (self _at: n) copy ].
%

