!========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id: quadbytesymbol.gs,v 1.14.6.1 2008-04-16 18:43:00 dhenrich Exp $
!
! ========================================================================

! Gs64 v3.0 QuadByteSymbol always created by bom.c

removeallmethods QuadByteSymbol
removeallclassmethods QuadByteSymbol
set class QuadByteSymbol

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'A QuadByteSymbol is a Symbol based on QuadByteStrings using characters
 requiring 4 bytes to represent them.' .
%

! ------------------- Class methods for QuadByteSymbol

category 'Instance Creation'
classmethod:
new: aSize

"Disallowed."
self shouldNotImplement: #new:
%

category 'Instance Creation'
classmethod:
new

"Disallowed."
self shouldNotImplement: #new
%
! edits for 41699
classmethod:
withAll: aString

"Returns a canonical symbol that has the same Characters as aString."

<primitive: 300> 
^ Symbol withAll: aString
%
classmethod: 
_newString

"Returns a new instance of String."

^ QuadByteString new
%
classmethod: 
_newString: aSize

"Returns a new instance of String."

^ QuadByteString new: aSize
%

! removed _decompress, inherit from Object
category: 'Class Membership'
method: 
species
  "(R) Returns a class similar to, or the same as, the receiver's class which
   can be used for containing derived copies of the receiver."

  ^ QuadByteString
%
category: 'Converting'
method:
keywords

"Returns an Array of the keywords in the receiver, treating
 any colon-delimited segment as if it was a legal keyword."

^ Symbol _keywords: self
%


category: 'Copying'
method: 
copyReplacing: oldObject withObject: newObject
	"Returns a String comprising a copy of the receiver in which all occurrences
	 of objects equal to oldObject have been replaced by newObject."

	^self asQuadByteString copyReplacing: oldObject withObject: newObject
%
category: 'New Indexing Comparison'
set compile_env: 0
method:
_idxForCompareEqualTo: aCharacterCollection collator: anIcuCollator
  ""

  ^ aCharacterCollection _idxForCompareEqualToQuadByteSymbol: self
%
category: 'New Indexing Comparison'
set compile_env: 0
method:
_idxForSortEqualTo: aCharacterCollection collator: anIcuCollator
  ""

  ^ self asString
    _idxForSortEqualTo: aCharacterCollection
    collator: anIcuCollator
%
category: 'New Indexing Comparison'
set compile_env: 0
method:
_idxForSortNotEqualTo: aCharacterCollection collator: anIcuCollator
  ""

  ^ (self _idxForSortEqualTo: aCharacterCollection collator: anIcuCollator) not
%
category: 'New Indexing Comparison'
set compile_env: 0
method:
_idxForCompareEqualTo: arg
  ""

  ^ arg _idxForCompareEqualToQuadByteSymbol: self
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareEqualToUnicode: aUnicodeString collator: aCollator
"second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:collator:."

  ^ false
%

category: 'Converting'
method:
asString

"Returns a copy of the receiver as a String."

^ String withAll: self.
%
category: 'Comparing'
method:
= anObject

"Returns true if anObject is equal to the receiver.  Since symbols 
 are canonicalized, this method does the check based on the 
 identities of the receiver and the argument."

^ self == anObject. 
%
category: 'Comparing'
method:
~= aCharCollection

"This method can be optimized for symbols since they are canonical."

^ self ~~ aCharCollection
%
category: 'Comparing'
method:
hash

"Returns a numeric hash key for the receiver.
 This implementation for new databases only and is
 replaced in the upgrade scripts."

^ self identityHash
%


category: 'Instance Creation'
classmethod:
_existingWithAll: aString

"Returns an existing canonical symbol that has the same value as 'aString'.  
 If no such Symbol, DoubleByteSymbol or QuadByteSymbol already exists, returns nil."

"This method is useful in processing Strings that are supposed to be names
 of already existing instance variables, such as in indexing and sorting."

<primitive: 310>
aString _validateClass: CharacterCollection .
^ self _existingWithAll: aString asString .
%

category: 'Instance Creation'
classmethod:
_basicNew: aSize
^ self shouldNotImplement: #_basicNew:
%

category: 'Instance Creation'
classmethod:
_basicNew
^ self shouldNotImplement: #_basicNew
%

    category: 'Instance Creation'
classmethod:
migrateNew

"Override default migrateNew behavior with #_basicNew."

^ self _basicNew
%

category: 'Storing and Loading'
classmethod:
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| theSize str marker result |

"since Symbols can't refer to other objects, the 'hasRead:' message
 may be sent after values have been filled in."

theSize := passiveObj readSize . 
str := String new: theSize .
marker := passiveObj objectPositionMarker .
passiveObj next: theSize bytesTo: str ;  
           next .
result :=  (str _changeClassToMultiByte: QuadByteString) asSymbol .
passiveObj hasRead: result marker: marker .
^ result
%

category: 'Concatenating'
method:
, aCharOrCharCollection

"Returns a new instance of DoubleByteString that contains the elements of
 the receiver followed by the elements of aCharOrCharCollection.
 A DoubleByteString is returned rather than a DoubleByteSymbol to avoid 
 the expense of unnecessary creation and canonicalization of Symbols."

| result |

result := QuadByteString withAll: self .
result  addAll: self; addAll: aCharOrCharCollection.
^ result
%

category: 'Converting'
method:
-> anObject

"Returns a SymbolAssociation with the receiver as the key and the given object
 as the value."

^ SymbolAssociation newWithKey: self value: anObject
%

category: 'Compatiblity'
method:
argumentCount

 ^ self numArgs
%
category: 'Converting'
method:
asSymbol

"Returns the receiver."

^ self
%

category: 'Converting'
method:
asSymbolKind

"Returns the receiver.  "

^ self
%

category: 'Clustering'
method:
cluster

"Has no effect.  Clustering of symbols is only performed by
 the clusterAllSymbols method in class System . "

^ true
%
category: 'Clustering'
method:
clusterInBucket: aClusterBucketOrId

"Has no effect.  Clustering of symbols is only performed by
 the clusterAllSymbols method in class System . "

^ true
%

category: 'Copying'
method:
copy

"Returns self.  Copies of (canonical) symbols are not allowed."

^ self
%

category: 'Testing'
method:
precedence

"Returns the precedence of the receiver, were it a message selector, with
 1=unary, 2=binary and 3=keyword."

^self isInfix
    ifTrue: [ 2 ]
    ifFalse: [ self isKeyword ifTrue: [ 3 ]
                              ifFalse: [ 1 ] ]
%

category: 'Formatting'
method:
printOn: aStream

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

aStream nextPut: $# .
super printOn: aStream
%

category: 'Copying'
method:
shallowCopy

"Returns self.  Copies of symbols are not allowed."

^ self
%
category: 'Private'
method:
speciesForConversion

^ QuadByteString .
%

category: 'Formatting'
method:
withNoColons

"Returns a String containing the value of the receiver with all colons removed.

 A String is returned rather than a symbol to avoid the expense of unnecessary
 creation and canonicalization of symbols."

^ self copyWithout: $:   .
%

category: 'Decompiling without Sources'
method:
_asSource

| result |
result := String new .
result add: $#  .
result addAll: super _asSource .
^ result
%

category: 'New Indexing Comparison'
method:
_idxForSortEqualTo: arg
  ""

  ^ super _idxForSortEqualToSymbol: arg
%
category: 'New Indexing Comparison'
method:
_idxForSortEqualToSymbol: aSymbol
  "second half of a double dispatch call from Symbol>>_idxForSortEqualTo:."

  ^ self asString _idxPrimCompareEqualTo: aSymbol asString
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareEqualToCharacterCollection: aCharacterCollection
  "second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:."

  ^ false
%
category: 'Class Membership'
classmethod: 
_classHistoryIncludesIdentical: aClass
  ^ aClass == Symbol or:[ aClass == DoubleByteSymbol or:[ aClass == QuadByteSymbol]]
%
category: 'Class Membership'
classmethod:
isSubclassOf: aClassHistoryOrClass
  
  (self _classHistoryIncludesIdentical: aClassHistoryOrClass) ifTrue:[ ^ true].
  ^ super isSubclassOf: aClassHistoryOrClass
%

