! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.

! file    processorscheduler2.gs

category: 'Private'
method: ProcessorScheduler
_initCriticalMethods

  "Methods which an in-process debugger should not set breakpoints in nor
    single step through."

  | arr set |
  arr := { 
    "primitive 457"
    CriticalSection  . #_scheduler .
    Delay  . #_scheduler .
    Delay class  . #_scheduler .
    GsProcess  . #_scheduler .
    GsProcess class  . #_scheduler .
    GsSocket  . #_scheduler .
    Processor class  . #_scheduler .
    ProcessorScheduler class  . #scheduler .
    Semaphore  . #_scheduler .

    "senders scheduler"
    AbstractException  . #_signalTimeout .
    ProcessorScheduler class  . #topazAllProcesses .
    ProcessorScheduler class  . #topazStatusForProcess: .
    ProcessorScheduler class  . #_allProcessesTerminate9 .

    "senders _scheduler"
    CriticalSection  . #critical: .
    Delay  . #signal .
    Delay  . #_cancel: .
    Delay  . #_wait: .
    Delay class  . #waitForMilliseconds: .
    Delay class  . #waitForSeconds: .
    Delay class  . #waitUntilMilliseconds: .
    Delay class  . #_highPriorityWaitForMilliseconds: .
    GsNMethod class  . #_terminateNonForkedProcess .
    GsProcess  . #priority: .
    GsProcess  . #resume .
    GsProcess  . #suspend .
    GsProcess  . #terminate .
    GsProcess  . #_activate .
    GsProcess  . #_continue .
    GsProcess  . #_finishTermination .
    GsProcess  . #_newGroup .
    GsProcess  . #_raisePriority .
    GsProcess  . #_reapSignal: .
    GsProcess  . #_signalAll .
    GsProcess  . #_signalJoiners .
    GsProcess  . #_start .
    GsProcess  . #_statusString .
    GsProcess  . #_stepOverInFrame:mode:replace:tos: .
    GsProcess  . #_unscheduleProcess .
    GsProcess  . #_wait .
    GsProcess class  . #_forkBlock:with:env:prio: .
    GsProcess class  . #_newForBlock:with:env: .
    GsSocket  . #readWillNotBlockWithin: .
    GsSocket  . #writeWillNotBlockWithin: .
    GsSocket  . #_waitForReadReady .
    GsSocket  . #_waitForWriteReady .
    Processor class  . #activePriority .
    Processor class  . #activeProcess .
    Processor class  . #allProcesses .
    Processor class  . #cancelWhenReadable:signal: .
    Processor class  . #cancelWhenWritable:signal: .
    Processor class  . #highestPriority .
    Processor class  . #highIOPriority .
    Processor class  . #lowestPriority .
    Processor class  . #lowIOPriority .
    Processor class  . #readyProcesses .
    Processor class  . #suspendedProcesses .
    Processor class  . #systemBackgroundPriority .
    Processor class  . #timingPriority .
    Processor class  . #userBackgroundPriority .
    Processor class  . #userInterruptPriority .
    Processor class  . #userSchedulingPriority .
    Processor class  . #waitingProcesses .
    Processor class  . #whenReadable:signal: .
    Processor class  . #whenWritable:signal: .
    Processor class  . #yield .
    Semaphore  . #highPriorityWaitForMilliseconds: .
    Semaphore  . #signal .
    Semaphore  . #signalAll .
    Semaphore  . #wait .
    Semaphore  . #waitForMilliseconds: .

    "implem _exitCritical"
    ProcessorScheduler  . #_exitCritical .
    Semaphore  . #_exitCritical .

    "senders _exitCritical"
    Delay  . #_wait: .
    Delay class  . #_highPriorityWaitForMilliseconds: .
    GsProcess  . #terminate .
    GsProcess  . #_activate .
    GsProcess  . #_continue .
    GsProcess  . #_signalJoiners .
    GsProcess  . #_stepOverInFrame:mode:replace:tos: .
    ProcessorScheduler  . #waitingProcesses .
    ProcessorScheduler  . #_allProcessesInto: .
    ProcessorScheduler  . #_allProcessesInto:inGroup: .
    ProcessorScheduler  . #_terminateScheduledProcess: .
    ProcessorScheduler  . #_waitForMilliseconds: .
    ProcessorScheduler  . #_waitForSocket:timeout:forWrite: .
    Semaphore  . #highPriorityWaitForMilliseconds: .
    Semaphore  . #signal .
    Semaphore  . #signalAll .
    Semaphore  . #wait .
    Semaphore  . #waitForMilliseconds: .

    "primitive: 737"
    ProcessorScheduler  . #_endYield .

    "primitive: 693"
    GsProcess . #_current  .
    GsProcess class . #_current  .
    ProcessorScheduler . #activeProcess  .

    "primitive: 736"
    ProcessorScheduler . #waitingProcesses  .
    ProcessorScheduler . #yield  .
    ProcessorScheduler . #_allProcessesInto:  .
    ProcessorScheduler . #_allProcessesInto:inGroup:  .
    ProcessorScheduler . #_enterCritical  .
    ProcessorScheduler . #_runNextProcess  .
    ProcessorScheduler . #_terminateScheduledProcess:  .
    ProcessorScheduler . #_yieldForTimeout  .
    ProcessorScheduler . #readyProcesses  .
    Semaphore . #signal  .
    Semaphore . #signalAll  .
    Semaphore . #wait  .

   "senders _reschedule:"
    ProcessorScheduler . #_suspendProcess:  .
    ProcessorScheduler . #_waitForMilliseconds:  .
    ProcessorScheduler . #_waitForSocket:  .
    ProcessorScheduler . #_waitForSocket:timeout:forWrite:  .
    ProcessorScheduler . #_waitOnSema:  .

    "senders _endYield"
    ProcessorScheduler  . #yield .
    ProcessorScheduler  . #_findReadyProcess: .
    ProcessorScheduler  . #_findReadyProcessForExit: .
    ProcessorScheduler  . #_runNextProcess .
    ProcessorScheduler  . #_yieldForTimeout .

    "other"
    ProcessorScheduler  . #_reapEvents:honorOob: .
    ProcessorScheduler  . #_checkForExpiredDelays: .
    ProcessorScheduler . #_now  .
    ProcessorScheduler . #_timeoutNow:  .
    ProcessorScheduler . #_delayUnschedule:  .
    ProcessorScheduler . #_switchFrom:to:  .
    ProcessorScheduler . #_runNextProcess  .
    ProcessorScheduler . #_reschedule:  .
    ProcessorScheduler . #_doPoll:yield:  .
    ProcessorScheduler . #_isWhenReadableSet:signal:  .
    ProcessorScheduler . #_isWhenWritableSet:signal:  .
    ProcessorScheduler . #whenReadable:signal:  .
    ProcessorScheduler . #whenWritable:signal:  .
    ProcessorScheduler . #cancelWhenReadable:signal:  .
    ProcessorScheduler . #cancelWhenWritable:signal:  .
    ProcessorScheduler . #_unschedule:  .
    ProcessorScheduler . #_suspendNewProcess:  .
    ProcessorScheduler . #_resumeProcess:  .
    ProcessorScheduler . #_waitingProcessesInto:  .
    ProcessorScheduler . #_waitingProcessesInto:inGroup:  .
    ProcessorScheduler . #suspendedProcesses  .
    ProcessorScheduler . #_add:toSet:  .
    ProcessorScheduler . #_remove:fromSet:  .
    ProcessorScheduler . #_changePriority:from:  .
    ProcessorScheduler . #_addReadyProcess:to:  .
    ProcessorScheduler . #_addDelay:to:  .
    ProcessorScheduler . #_updateTimerThread:priority:  .
    ProcessorScheduler . #_sizeNoShrink:  .
    ProcessorScheduler . #_allStacksReport .

    GsProcess .  #resume  .

    GsProcess class . #_newForBlock:with:env:  .
    GsProcess . #_init:args:env:stackSerial:forked:  .
    GsProcess class . #_forkBlock:with:env:prio:  .
    ProcessorScheduler . #_scheduleNewProcess:prio:  
  }.
  set := IdentitySet new .
  1 to: arr size by: 2 do:[:n |
    | cls sel meth |
    cls := arr at: n .
    sel := arr at: n + 1 .
    meth := cls compiledMethodAt: sel otherwise: nil .  
    meth ifNotNil:[ set add: meth ] 
         ifNil:[ Error signal: sel , ' not found in ' , cls name  ].
  ].
  criticalMethods := set .
  ^ set
%

