!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! more methods for Object 
!
! Superclass Hierarchy:
!   Object.
!
!=========================================================================
 
! do not remove methods

set class Object
category: 'Error Handling'

method: 
_error: errorSymbol
  "Will be deprecated."
  | errNum cls |
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum) 
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ; args: { self } ; signal 
%

category: 'Error Handling'
method: Object
_error: errorSymbol with: argOne
  "Will be deprecated."
  | errNum cls |
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum) 
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ; 
		args: { self . argOne } ; signal
%

category: 'Error Handling'
method: Object
_error: errorSymbol args: argList
  "Will be deprecated."

  | newArgList cls errNum |
  newArgList := { self } .
  newArgList addAll: argList .
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum) 
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ;
                args: newArgList ;  signal
%

!  _errorNotOnlyUser: deleted, no senders


category: 'Updating'
classmethod: Object
_checkKindForBecome: anObj

"determine reason for primitive failure of become"
| arr |

anObj isSpecial ifTrue: [ ^ anObj _error: #rtErrCantBecomeSpecial ].

anObj _isExecBlock ifTrue: [ 
   ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind ; _number: 2121; object: anObj ;
	details: 'become not allowed on ExecBlocks  '; signal
].
(anObj _isSymbol ) ifTrue: [ 
   ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind ; _number: 2121; object: anObj ;
	details: 'become not allowed on Symbols  '; signal
].

arr := { Behavior . GsNMethod .   " to avoid breaking VM"
   GsMethodDictionary . SymbolDictionary . SymbolList .  "for code security"
   "following have CData" GsSocket . GsFile . 
     GsCompilerIRNode . CBuffer . CByteArray . CFunction . CLibrary . CPointer . 
     CZstream }.
1 to: arr size do:[:n || cls |
  cls := arr at: n .
  (anObj isKindOf: cls) ifTrue:[ 
    ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind; _number: 2121 ; object: anObj;
       details: 'become not allowed on instances of ' , cls name ; signal .
  ]
].
%

! extent0.ruby.dbf overrides implementation of _doesNotUnderstand:args:envId:reason:

! fixed 41026 , 47448
category: 'Error Handling'
method: Object
cantPerform: aSelectorSymbol withArguments: anArray
	"This method implements the default response when a message can't be performed
 with _perform:withArguments:.  It raises the rtErrCantPerform exception."
  | ex |
	aSelectorSymbol numArgs == anArray size ifTrue:[ 
     ^ self doesNotUnderstand: (Message selector: aSelectorSymbol arguments: anArray)
  ].
  (ex := ArgumentError new) _number: 2263; args: { aSelectorSymbol . self . anArray };
         details: 'wrong number of args for selector' .
  ^ ex signal .    
%

category: 'Error Handling'
method: Object
cantPerform: aSelectorSymbol withArguments: anArray env: envId
  | ex |
  envId == 0 ifTrue:[
    ^ self cantPerform: aSelectorSymbol withArguments: anArray
  ].
  aSelectorSymbol numArgs == anArray size ifTrue:[
    (ex := MessageNotUnderstood _basicNew)
       receiver: self selector: aSelectorSymbol args: anArray envId: envId .
    ^ex signal .  "fix for #40871"
  ].
  (ex := ArgumentError new) _number: 2263; 
         args: { aSelectorSymbol . self . anArray . envId };
         details: 'wrong number of args for selector' .
  ^ ex signal .    
%
 
category: 'Instance Migration'
method: Object
migrateFrom: anotherObject

"Takes information from the given object and puts it in the receiver.
 This message is sent to an object when its class is being migrated to
 another class using migrate, but not when using migrateInstances:to:.
 To customize migration, the method migrateFrom:instVarMap: should be 
 reimplemented in subclasses. 

 Dynamic instVars in anotherObject preserved by default. 

 Note: If the receiver is a kind of Bag or IdentityBag, then the receiver may
 have objects from anotherObject added to it."

^self migrateFrom: anotherObject
      instVarMap: (InstVarMappingArray mappingFrom: anotherObject class to: self class)
%

category: 'Repository Conversion'
method: Object
fixRefsAfterConversion

"Default method for fixing references ObsLargePositiveInteger and
 ObsLargeNegativeInteger instances that can now be represented as
 a SmallInteger and Floats and SmallFloats which can now be represented as
 a SmallDouble."

| convBm |
convBm := (GsBitmap newForHiddenSet: #Conversion).
(convBm includes: self)
        ifTrue:[^false]. "already fixed this one"

self isInternalObject
        ifFalse:[
                self fixInstVarRefsAfterConversion.
                self fixIndexableRefsAfterConversion.
        ].

convBm add: self.
^true
%
category: 'Private'
method: Object
_unsafeAt: anIndex
"Low level access to an object, node of a large object , or node of
 an IdentityBag
 Named instance variables are accessed by this method, so
 unnamed instance variables begin at (self class instSize + 1).

 Returns specifed instVar of the object.  If object is byte format,
 returns SmallInteger value of the specified byte.
 If anIndex is < 1 , the primtive fails.
 If anIndex is beyond the end of the object, returns OOP_REMOTE_NIL"

 <primitive: 596>
 (anIndex _isInteger)
   ifFalse: [ self _errorNonIntegerIndex: anIndex .  self _uncontinuableError ].
 self _primitiveFailed: #_unsafeAt: args: { anIndex } .
 self _uncontinuableError
%

