expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #UUID otherwise: nil.
oldCls == nil ifTrue: [
    Stream subclass: 'Random'
	instVarNames: #( seed hi lo)
	classVars: #( a m q r)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'Random'.
	newCls category: 'Random'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].

%

! Remove existing behavior from Random
removeallmethods Random
removeallclassmethods Random
! ------------------- Class methods for Random
category: '(as yet unclassified)'
set compile_env: 0
classmethod: Random
initialize

  "Class initialization"

  a := 16807.0.
  m := 2147483647.0.
  q := m // a.
  r := m \\ a.
%
category: 'For Documentation Installation only'
set compile_env: 0
classmethod: Random
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'Class Random is a port of Jeff Sutherland''s implementation of the
 Park & Miller random number generator.

From Jeff Sutherland''s original posting:

"In summary...(this is) a generator which has a full period, is
demonstrably random, and can be implemented correctly on almost
any system.  The generator has been exhaustively tested and its
characteristics are well understood... Moreover, it has become a
standard ... subroutine DNUN in the IMSL library and ... DRAND
in the simulation language SLAM II...  we feel confident in
recommending this random number generator as a minimal standard
against which all others should be judged."

This code has received minimal testing on an IBM P75 486 machine
and may break on a Pentium.  It is written in Enfin Smalltalk but
a port to another Smalltalk is trivial.  The validate function works
but any bugs you find are surely mine.  Send me a note at
jsutherland@vmark.com.' .
doc documentClassWith: txt.

self description: doc.
%
category: 'Instance Creation'
set compile_env: 0
classmethod: Random
new
 ^super new initialize.
%
category: 'Instance Creation'
set compile_env: 0
classmethod: Random
seed: anInteger 
	^self new seed: anInteger
%
category: 'Testing'
set compile_env: 0
classmethod: Random
speed
       "Random speed will benchmark the efficiency of random number
generation"

|rand|

rand := self new.

^(System millisecondsToRun: [ 1000 timesRepeat: [rand next]
  ]) / 1000.0
%
category: 'Testing'
set compile_env: 0
classmethod: Random
testRandom
       "Random testRandom will check your hardware environment"
|num|
num := Random new initialize.
num seed: 1.
10000 timesRepeat: [
  num next.
].
(1043618065 = num seed)
  ifTrue: [ ^'OK.' ]
  ifFalse: [ ^'Bad result. Fix this generator
             by referring to Park & Miller,^M
             Communications of the ACM 31:10:1192-1201, 1988.' ].
%
! ------------------- Instance methods for Random
category: 'testing'
set compile_env: 0
method: Random
atEnd
 "Answer false that the stream is not at an end."

 ^false
%
category: 'accessing'
set compile_env: 0
method: Random
between: min and: max

   "Return a random value x such that min <= x < max"

  ^(self next * (max - min)) + min
%
category: 'accessing'
set compile_env: 0
method: Random
contents
 "Random numbers do not have a contents so provide
 an error notification."

 ^self shouldNotImplement: #contents
%
category: 'accessing'
set compile_env: 0
method: Random
flush
 "Random numbers do not need to flush."

 ^self shouldNotImplement: #flush
%
category: 'Private'
set compile_env: 0
method: Random
initialize

  "Initialize an instance, seeded by the time of day"

  self seed: (System _timeMs \\ 2147483646) + 1
%
category: 'Accessing'
set compile_env: 0
method: Random
next
 "Answer the next random number."

"Real Random Number generator Version 2 from Park and Miller, 1988"
  hi := self seed quo: q.
  lo := seed - (q * hi).
  seed := (a * lo) - (r * hi).
  seed > 0 ifFalse: [
    seed := seed + m].
  ^ seed / m.
%
category: 'accessing'
set compile_env: 0
method: Random
nextInt: anInteger
	"Answer a random integer in the interval [1, anInteger]."

	anInteger strictlyPositive ifFalse: [ self error: 'Range must be positive' ].
	^ (self next * anInteger) truncated + 1
%
category: 'accessing'
set compile_env: 0
method: Random
nextPut: anObject
 "Random numbers do not implement nextPut: so provide an
 error notification."

 ^self shouldNotImplement: #nextPut:
%
category: 'Accessing'
set compile_env: 0
method: Random
seed

   "Return the value of the instance variable 'seed'."
   ^seed
%
category: 'Initialization'
set compile_env: 0
method: Random
seed: aSeed
  (aSeed <= 0 or:[aSeed >= 2147483646]) ifTrue:[ 
     self error:'seed out of range'
  ].
  seed := aSeed.
  hi := lo := nil.
%

doit
Random initialize.
true
%

