category: '*gsmonticello'
method: CharacterCollection
withSqueakLineEndings
	"Assume the string is textual, and that CR, LF, and CRLF are all valid line endings.
	Replace each occurence with a single CR."
	| cr lf inPos outPos outString newOutPos indexLF indexCR |
	lf := Character lf.
	indexLF := self indexOf: lf startingAt: 1.
	indexLF = 0 ifTrue: [^self].
	
	cr := Character cr.
	indexCR := self indexOf: cr startingAt: 1.
	indexCR = 0 ifTrue: [^self copy replaceAll: lf with: cr].

	inPos := outPos := 1.
	outString := String new: self size.

	["check if next CR (if any) is before next LF"
	(indexCR > 0 and: [indexCR < indexLF])
		ifTrue: [
			newOutPos := outPos + 1 + indexCR - inPos.
			outString replaceFrom: outPos to: newOutPos - 1 with: self startingAt: inPos.
			outPos := newOutPos.
			1 + indexCR = indexLF
				ifTrue: ["Caught a CR-LF pair"
					inPos := 1 + indexLF.
					indexLF := self  indexOf: lf startingAt: inPos]
				ifFalse: [inPos := 1 + indexCR].
			indexCR := self indexOf: cr startingAt: inPos]
		ifFalse: [
			newOutPos := outPos + 1 + indexLF - inPos.
			outString replaceFrom: outPos to: newOutPos - 2 with: self startingAt: inPos.
			outString at: newOutPos - 1 put: cr.
			outPos := newOutPos.
			inPos := 1 + indexLF.
			indexLF := self indexOf: lf startingAt: inPos].
	indexLF = 0]
		whileFalse.

	"no more LF line endings.  copy the rest"
	newOutPos := outPos + (self size - inPos + 1).
	outString replaceFrom: outPos to: newOutPos - 1 with: self startingAt: inPos.
	^outString copyFrom: 1 to: newOutPos - 1
%

category: '*gsmonticello'
method: CharacterCollection
replaceAll: oldObject with: newObject
	"Replace all occurences of oldObject with newObject"

	| index |
	index := self indexOf: oldObject startingAt: 1 ifAbsent: [ 0 ].
	[ index = 0 ]
		whileFalse: [ 
			self at: index put: newObject.
			index := self indexOf: oldObject startingAt: index + 1 ifAbsent: [ 0 ] ]
%

category: '*gsmonticello'
method: CharacterCollection
withGemStoneLineEndings
	"Assume the string is textual, and that CR, LF, and CRLF are all valid line endings.
	Replace each occurence with a single LF."
	| cr lf inPos outPos outString newOutPos indexLF indexCR |
	cr := Character cr.
	indexCR := self indexOf: cr startingAt: 1.
	indexCR = 0 ifTrue: [^self].
	
	lf := Character lf.
	indexLF := self indexOf: lf startingAt: 1.
	indexLF = 0 ifTrue: [^self copy replaceAll: cr with: lf].

	inPos := outPos := 1.
	outString := String new: self size.

	["check if next CR (if any) is before next LF"
	(indexCR > 0 and: [indexCR < indexLF])
		ifTrue: [
			newOutPos := outPos + 1 + indexCR - inPos.
			outString replaceFrom: outPos to: newOutPos - 2 with: self startingAt: inPos.
			outString at: newOutPos-1 put: lf.
			outPos := newOutPos.
			1 + indexCR = indexLF
				ifTrue: ["Caught a CR-LF pair"
					inPos := 1 + indexLF.
					indexLF := self  indexOf: lf startingAt: inPos]
				ifFalse: [
					inPos := 1 + indexCR].
			indexCR := self indexOf: cr startingAt: inPos.
			indexCR > indexLF
				ifTrue: [ indexLF := self  indexOf: lf startingAt: indexCR]]
		ifFalse: [
			newOutPos := outPos + 1 + indexCR - inPos.
			outString replaceFrom: outPos to: newOutPos - 2 with: self startingAt: inPos.
			outString at: newOutPos - 1 put: lf.
			outPos := newOutPos.
			inPos := 1 + indexCR.
			indexCR := self indexOf: cr startingAt: inPos].
	indexCR = 0]
		whileFalse.

	"no more CR line endings.  copy the rest"
	newOutPos := outPos + (self size - inPos + 1).
	outString replaceFrom: outPos to: newOutPos - 1 with: self startingAt: inPos.
	^outString copyFrom: 1 to: newOutPos - 1
%

category: '*gsmonticello'
method: CharacterCollection
findString: subString startingAt: startIndex caseSensitive: caseSensitive 

"If a receiver contains subString beginning at some point at or after
 startIndex, this returns the index at which subString begins.  If the
 receiver does not contain subString, this returns 0."

^ self _findString: subString startingAt: startIndex ignoreCase: caseSensitive not
%

category: '*gsmonticello'
method: CharacterCollection
isAllSeparators
	"whether the receiver is composed entirely of separators"
	self do: [ :c | c isSeparator ifFalse: [ ^false ] ].
	^true
%

category: '*gsmonticello'
method: CharacterCollection
isString

    ^true
%

category: '*gsmonticello'
method: CharacterCollection
skipDelimiters: delimiters startingAt: start 
	"Answer the index of the character within the receiver, starting at start, that does NOT match one of the delimiters. If the receiver does not contain any of the delimiters, answer size + 1.  Assumes the delimiters to be a non-empty string."

        | aChar j |
	start to: self size do: [:i |

           j := i .  "to allow to:do: to be inlined"
           aChar := self at: j .

	   delimiters detect: [:delim | delim = aChar] ifNone: [^ j ]].
	^ self size + 1
%

category: '*gsmonticello'
method: CharacterCollection
findTokens: delimiters
	"Answer the collection of tokens that result from parsing self.  Return strings between the delimiters.  Any character in the Collection delimiters marks a border.  Several delimiters in a row are considered as just one separation.  Also, allow delimiters to be a single character."

	| tokens keyStart keyStop separators |

	tokens _ OrderedCollection new.
	separators _ delimiters isCharacter 
		ifTrue: [Array with: delimiters]
		ifFalse: [delimiters].
	keyStop _ 1.
	[keyStop <= self size] whileTrue:
		[keyStart _ self skipDelimiters: separators startingAt: keyStop.
		keyStop _ self findDelimiters: separators startingAt: keyStart.
		keyStart < keyStop
			ifTrue: [tokens add: (self copyFrom: keyStart to: (keyStop - 1))]].
	^tokens
%

category: '*gsmonticello'
method: CharacterCollection
findDelimiters: delimiters startingAt: start 
	"Answer the index of the character within the receiver, starting at start, that matches one of the delimiters. If the receiver does not contain any of the delimiters, answer size + 1."

	start to: self size do: [:i |
		delimiters do: [:delim | delim = (self at: i) ifTrue: [^ i]]].
	^ self size + 1
%

