!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

expectvalue %String
run
  JapaneseString _newKernelByteSubclass: 'JISString'
    classVars: #()
    poolDictionaries: { }
    inDictionary: Globals
    options: #() 
    reservedOop: 769
%

removeallmethods JISString
removeallclassmethods JISString

category: 'For Documentation Installation only'
classmethod: JISString
installDocumentation

self comment:
'Deprecated in 3.0 and later, replaced by Extended Character Set support
 and DoubleByteStrings/QuadByteStings.

 JISString represents Japanese strings containing JISCharacters.  Each
 Character in a JISString occupies two bytes.'.
%

category: 'Formatting'
classmethod: JISString
charSize

"Returns the number of bytes that make up a character"
^2
%

category: 'Formatting'
method: JISString
charSize

"Returns the number of bytes that make up a character"
^2
%

category: 'Concatenating'
method: JISString
, aCharOrCharColl

"Returns a new instance of the receiver's class that contains the elements of
 the receiver followed by the elements of aCharOrCharColl.

 Note: Creating a new instance and copying the receiver take time.  If you can
 safely modify the receiver, it is faster to use the addAll: method."
 | res  |
 (res := JISString new) addAll: self;
               addAll: aCharOrCharColl.
 ^ res
%

category: 'Accessing'
method: JISString
at: anIndex

"Returns the JISCharacter at anIndex."

| highByte lowByte offset |

offset := anIndex + anIndex  .
lowByte := self _basicAt: offset .
highByte := self _basicAt: offset - 1 .
 ^ JISCharacter withValue: highByte * 256 + lowByte
%

category: 'Accessing'
method: JISString
size

"Returns the size of the receiver in Characters."

^ self _basicSize // 2
%

category: 'Updating'
method: JISString
at: anIndex put: aCharacter

"Stores aCharacter at the specified location."

| offset val highByte lowByte |
offset := anIndex + anIndex  .
val := aCharacter asJISCharacter jisValue .
highByte := val // 256 .
lowByte :=  val \\ 256 .
self _basicAt: offset - 1 put: highByte .
self _basicAt: offset     put: lowByte .
^ aCharacter
%

category: 'Updating'
method: JISString
size: anInteger

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to nil."

^ self _basicSize: anInteger + anInteger 
%

category: 'Formatting'
method: JISString
asJISString

"Returns the receiver."

"This reimplementation from JapaneseString is crucial!"

^self
%

category: 'Converting'
method: JISString
asSymbolKind

"Returns a copy of the receiver as an instance of class Symbol."

^ self asSymbol

%

category: 'Searching'
method: JISString
indexOf: aCharacter startingAt: startIndex

"Returns the index of the first occurrence of aCharacter in the receiver,
 not preceding startIndex.  If the receiver does not contain aCharacter,
 this returns zero."

startIndex to: self size do:[:j|
  (self at:j ) == aCharacter ifTrue:[ ^ j ].
  ].
^ 0
%

! fixed 40865
category: 'Adding'
method: JISString
add: aCharOrCharCollection

"Appends aCharOrCharCollection to the receiver.  The argument
 aCharOrCharCollection must be a CharacterCollection or a kind of
 AbstractCharacter.
 Returns aCharOrCharCollection "

(aCharOrCharCollection isKindOf: Collection) ifTrue:[
   self addAll: aCharOrCharCollection.
   ^ aCharOrCharCollection 
 ].
self at: (self size + 1) put: aCharOrCharCollection .
^ aCharOrCharCollection
%

category: 'Adding'
method: JISString
addAll: aCharOrCharCollection

"Equivalent to add: aCharOrCharCollection."

| idx |

(aCharOrCharCollection isKindOf: Collection) ifTrue:[
  idx := self size . 
  aCharOrCharCollection do:[ :aChar |
    idx := idx + 1 .
    self at: idx put: aChar .
    ].
  ^ aCharOrCharCollection
  ].
^ self at: (self size + 1) put: aCharOrCharCollection
%

category: 'Adding'
method: JISString
addLast: aCharOrCharCollection

"Equivalent to add: aCharOrCharCollection."

^ self add: aCharOrCharCollection
%

category: 'Adding'
method: JISString
insertAll: aCharOrCharCollection at: anIndex

"Inserts aCharOrCharCollection at the specified index."

<primitive: 241>

anIndex _validateClass: SmallInteger.
(anIndex > (self size + 1))
ifTrue:[ ^ self _errorIndexOutOfRange: anIndex]
ifFalse:[ ^ super insertAll: aCharOrCharCollection at: anIndex]
%

category: 'Converting'
method: JISString
asSymbol

"Returns the receiver as a DoubleByteSymbol."

^ (DoubleByteString withAll: self) asSymbol
%

category: 'Indexing Support'
method: JISString
_isValidPathTermName

"Returns true if the receiver is a valid term in a path expression."

self deprecated:'_isValidPathTermName deprecated (JISString not supported path terms)'.
^ false 
%

category: 'Accessing'
method: JISString
codePointAt: anIndex

^ (self at: anIndex) jisValue
%

category: 'Updating'
method: JISString
codePointAt: anIndex put: aValue

^ self at: anIndex put:(JISCharacter withValue: aValue)
%

