!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   IdentityIndexQueryEvaluator, IndexedQueryEvaluator, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods IdentityIndexQueryEvaluator
removeallclassmethods IdentityIndexQueryEvaluator

category: 'For Documentation Installation only'
classmethod: IdentityIndexQueryEvaluator
installDocumentation

self comment:
'IdentityIndexQueryEvaluator is a concrete class that implements the behavior used to 
 evaluate queries against UnordedCollections that have identity indexes. This class is
 used in the internal implementation of indexing and should not be modified.'.
%

! ------------------- Class methods for IdentityIndexQueryEvaluator
! ------------------- Instance methods for IdentityIndexQueryEvaluator
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesEqualTo: aValue

"Identity indexes do not support equality comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesGreaterThanKey: aValue andEquals: aBoolean

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesIdenticalTo: aValue

"Returns a set of all values that satisfy the query."

| tmpHolder startPt res |

" optimize query for objects in the NSC itself "
self index isIndexOnRootNsc
    ifTrue: [
      doBlock 
        ifNil: [
          " optimize query for objects in the NSC itself "
          ^ self _allIdenticalTo: aValue in: self nscRoot ].
      ^ self _allIdenticalTo: aValue in: self nscRoot do: doBlock  ].

tmpHolder := NscBuilder for: self nscRoot species new max: self sizeForNscBuilder.

startPt := self index lastPathComponentsDictionaryOffset.
self index _addAllFor: aValue
    into: tmpHolder
    offset: startPt
    pathTerm: (self index at: startPt).

res := tmpHolder completeBag.
doBlock ifNotNil: [ res do: doBlock ].
^res
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesLessThanKey: aValue andEquals: aBoolean

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
findAllValuesNotEqualTo: aValue

"Identity indexes do not support equality comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueEqualTo: aValue

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueGreaterThanKey: aValue
andEquals: aBoolean

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueIdenticalTo: aValue

"Returns the first value that satisfies the query."

" optimize query for objects in the NSC itself "
self index isIndexOnRootNsc
    ifTrue: [
        (self nscRoot includesIdentical: aValue)
            ifTrue: [ ^ aValue ]
            ifFalse: [ ^ #_incompletePathTraversal ]
    ].

^ self _findFirstValueForKey: aValue
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueLessThanKey: aValue
andEquals: aBoolean

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Query Detect'
method: IdentityIndexQueryEvaluator
findFirstValueNotEqualTo: aValue

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex
%
category: 'Searching'
method: IdentityIndexQueryEvaluator
_findFirstKeyNotIdenticalTo: aKey atTerm: pathTerm

"Find the first entry with the given path term whose key is not identical to
 the given key and returns the entry's key."

^ self index indexDictionary _findFirstKeyNotIdenticalTo: aKey atTerm: pathTerm
%
category: 'Query Select'
set compile_env: 0
method: IdentityIndexQueryEvaluator
findAllValuesIdenticalTo: aValue do: aBlock
  "Iterates over all values that satisfy the query.  "

  ^ (self findAllValuesIdenticalTo: aValue) do: aBlock
%
category: 'Query Select'
method: IdentityIndexQueryEvaluator
_findAllValuesIdenticalToAsNsc: aValue
  "Answer a collecation of all values identical to aValue"

  | blk |
  blk := doBlock.
  [doBlock := nil.
  ^ self findAllValuesIdenticalTo: aValue ] ensure: [ doBlock := blk ]
%
