!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   Object, GsObjectInventory
!
!=========================================================================

expectvalue %String
run
^Object _newKernelSubclass: 'GsObjectInventoryEntry'
        instVarNames: #( theClass instanceCount byteCount)
        classVars: #()
        classInstVars: #()
        poolDictionaries: { }
        inDictionary: Globals
        options: #()
        reservedOop: 1139
%


removeallmethods GsObjectInventoryEntry
removeallclassmethods GsObjectInventoryEntry

! ------------------- Class methods for GsObjectInventoryEntry
category: 'Documentation'
classmethod: 
comment
^'A GsObjectInventoryEntry represents statistics for one Class,
generated by a GsObjectInventory.' 
%
! ------------------- Instance methods for GsObjectInventoryEntry
category: 'Formatting'
method: GsObjectInventoryEntry
asString

| result myName |
myName := self class name.
result := String new.
self theClass == nil
	ifTrue:[result addAll: 'An empty '; addAll: myName ]
	ifFalse:[ result addAll: 'a'; addAll: myName; addAll: ' for '; addAll: self theClass name].
^result

%
category: 'Accessing'
method: GsObjectInventoryEntry
byteCount

^byteCount
%
category: 'Updating'
method: GsObjectInventoryEntry
byteCount: newValue

byteCount := newValue
%
category: 'Accessing'
method: GsObjectInventoryEntry
instanceCount

^instanceCount
%
category: 'Updating'
method: GsObjectInventoryEntry
instanceCount: newValue

instanceCount := newValue
%
category: 'Accessing'
method: GsObjectInventoryEntry
theClass

^theClass
%
category: 'Updating'
method: GsObjectInventoryEntry
theClass: newValue

theClass := newValue
%
