!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ExecutableBlock, BlockClosure, Object.
!
!=========================================================================

removeallmethods ExecutableBlock
removeallclassmethods ExecutableBlock

category: 'For Documentation Installation only'
classmethod: ExecutableBlock
installDocumentation

self comment:
'ExecutableBlock and subclasses are obsolete in Gemstone64 v3.0 and above.'.
%

category: 'Accessing'
method: ExecutableBlock
argsAndTemps

"Return the value of the argsAndTemps instance variable."

^argsAndTemps
%

set compile_env: 0
category: 'Accessing'
method: ExecutableBlock
argumentCount
	"A SelectBlock can only take one argument."

	^self numberArgs.
%

category: 'Accessing'
method: ExecutableBlock
firstPC

"Return the value of the firstPC instance variable."

^firstPC
%

category: 'Accessing'
method: ExecutableBlock
firstSourceOffset

"Return the value of the firstSourceOffset instance variable."

^firstSourceOffset
%

! lastPC deleted

category: 'Accessing'
method: ExecutableBlock
lastSourceOffset

"Return the value of the lastSourceOffset instance variable."

^lastSourceOffset
%

category: 'Accessing'
method: ExecutableBlock
method

"Return the value of the method instance variable."

^method
%

category: 'Accessing'
method: ExecutableBlock
numberArgs

"Return the value of the numberArgs instance variable."

^numberArgs
%

category: 'Accessing'
method: ExecutableBlock
numberTemps

"Return the value of the numberTemps instance variable."

^numberTemps
%

! block value methods moved to Complex and Simple block classes

category: 'Private'
method: ExecutableBlock
_gbsTraversalCallback

"Private.  When GemBuilder Smalltalk traverses an ExecutableBlock, this method
 is called to place the block's source string in the traversal buffer."

^self _sourceString
%

category: 'Private'
method: ExecutableBlock
_gsReturnNoResult

"Returns from the block with no result left on the GemStone Smalltalk stack."

"To be sent only by the method _valueOnUnwind.
 Any other use corrupts the virtual machine's stack.  This is a special 
 selector in Object and is optimized by the compiler."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Private'
method: ExecutableBlock
_valueOnUnwind

"This method should be invoked only from within the virtual machine. Other
 use from a Smalltalk program will corrupt the Smalltalk execution
 stack."

"Used to implement valueNowOrOnUnwind:"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Obsolete'
method: ExecutableBlock
valueNowOrOnUnwindDo: aBlock
"Obsolete in GemStone/64. Use ensure: instead."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ExecutableBlock
ensure: aBlock
"Evaluate the receiver.  Evaluate aBlock after evaluating the receiver,
 or before any return from a block that would return to the sender."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Private'
method: ExecutableBlock
_installAsUnwindBlock

"Install the receiver as an unwind block."

"The sender must be executing with a VariableContext; if not, the 
 primitive will fail."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Flow of Control'
method: ExecutableBlock
untilFalse

"(Reserved selector.)  Evaluates the receiver repeatedly until the evaluation's
 result is false.  Return nil.  Generates an error if the receiver is not a
 zero-argument block."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Flow of Control'
method: ExecutableBlock
untilTrue

"(Reserved selector.)  Evaluates the receiver repeatedly until the evaluation's
 result is true.  Return nil.  Generates an error if the receiver is not a
 zero-argument block."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Flow of Control'
method: ExecutableBlock
whileFalse: aBlock

"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
 while the receiver evaluates to false.  Return nil.  Generates an error if the
 receiver is not a zero-argument block."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Flow of Control'
method: ExecutableBlock
whileTrue: aBlock

"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
 while the receiver evaluates to true.  Return nil.  Generates an error if the
 receiver is not a zero-argument block."

"The following is a control structure optimization, not a recursive send."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Accessing'
method: ExecutableBlock
_sourceString

"(Subclass responsibility.)"

^ ExecutableBlock subclassResponsibility: #_sourceString
%

category: 'Decompiling without Sources'
method: ExecutableBlock
_asSource

"return a stripped source representation of the block."

| result |
result := String new.
result addAll: self class name ;
  addAll: ' _with: #( ' ;
      "method will be supplied at regeneration time, so we skip it."
  addAll: firstPC asString ; add: $  ;
  addAll: numberArgs asString ; add: $  ;
  addAll: numberTemps asString ; add: $  ;
    "firstSourceOffset regenerated as 1"
    "lastSourceOffset regenerated as 1"
    "argsAndTemps regenerated as nil "
  addAll: ' ) ' .

^ result
%

category: 'Reloading Decompiled Methods'
method: ExecutableBlock
_method: aGsMethod 

"For use only when recreating blocks from decompiled methods.  Other
 use may cause incorrect execution of the GemStone Smalltalk virtual machine."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Reloading Decompiled Methods'
method: ExecutableBlock
_initialize: anArray

"For use only when recreating blocks from decompiled methods.  Other
 use may cause incorrect execution of the GemStone Smalltalk virtual machine."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Reloading Decompiled Methods'
classmethod: ExecutableBlock
_with: anArray

"For use only when recreating blocks from decompiled methods.  Other
 use may cause incorrect execution of the GemStone Smalltalk virtual machine."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Storing and Loading'
classmethod: ExecutableBlock
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| src result marker meth o symbolList |

"Returns a new instance of the receiver read from the given PassiveObject"

marker := passiveObj objectPositionMarker.
src := passiveObj readObject.
symbolList := GsCurrentSession currentSession symbolList .
meth := src _compileInContext: (o := Object new) symbolList: symbolList.
result := meth _executeInContext: o.
(result == nil or: [(result isKindOf: ExecutableBlock) not]) ifTrue: [
  "error in compiling"
  self _halt: 'Error in recreating a ' , name.
  ^nil
  ]
ifFalse: [
  passiveObj hasRead: result marker: marker.
  ^result
  ]
%

category: 'Storing and Loading'
method: ExecutableBlock
writeTo: aPassiveObject

"Converts the receiver to its passive form and writes that information on
 aPassiveObject.

 SimpleBlocks can usually be passivated and then reactivated.  ComplexBlocks
 can be passivated but may have to be massaged to be reactivated.  References
 to 'self' in complex blocks will resolve to an instance of Object when the
 block is activated, and any arguments or temporaries from enclosing scopes
 will be nil."

aPassiveObject writeClass: self class.
aPassiveObject writeObject: self _sourceString; cr
%

category: 'Modification Tracking'
method: ExecutableBlock
_setModificationTrackingTo: tracker

"Private.

 No modification tracking is required for blocks,
 even if they are not invariant."

^self
%

!
! Thread Support
!

category: 'Processes - Blue Book'
method: ExecutableBlock
fork
  "forks the receiver as a new process at the current scheduling priority"
  
self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes - Blue Book'
method: ExecutableBlock
forkAt: priority
  "forks the receiver as a new process at the given priority"
  
self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes'
method: ExecutableBlock
forkWith: blockArgs
  "forks the receiver as a new process at the current scheduling priority"
  
self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes'
method: ExecutableBlock
forkAt: priority with: blockArgs
  "forks the receiver as a new process at the given priority"
  
self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes - Blue Book'
method: ExecutableBlock
newProcess
  "creates a new process holding the receiver"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Processes - Blue Book'
method: ExecutableBlock
newProcessWith: argArray
  "creates a new process holding the receiver to be evaluated with the
   given arguments"

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

! deleted _fixKnownConversionErrors: result source: src symbolList: symbolList oldNamesDict: oldNamesDict oldLitVarsArray: oldLitVars

category: 'Block Evaluation'
method: ExecutableBlock
on: selector do: action

	"Try to evaluate the receiver, and should an exception occur which is matched
	by selector (normally a class object which is a subclass of ExceptionA but can
	also be an ExceptionSet instance with subclasses of ExceptionA or any other 
	object that matches the protocol defined for an ExceptionSelector), evaluate the 
	<monadicBlock>, action, passing it the exception instance as its argument."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%
category: 'Block Evaluation'
method: ExecutableBlock
onException: selector do: action

	"Try to evaluate the receiver, and should an exception occur which is matched
	by selector (normally a class object which is a subclass of ExceptionA but can
	also be an ExceptionSet instance with subclasses of ExceptionA or any other 
	object that matches the protocol defined for an ExceptionSelector), evaluate the 
	<monadicBlock>, action, passing it the exception instance as its argument."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

