! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id$
!
! ========================================================================

expectvalue %String
run
Object _newKernelSubclass: #CBuffer
  instVarNames: #(#offset)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
  reservedOop: 923
%
removeallmethods CBuffer
removeallclassmethods CBuffer

! ------------------- Class methods for CBuffer
category: 'For Documentation Installation only'
classmethod
installDocumentation

self comment:
'CBuffer represents a an instance of some C or C++ type allocated in C heap
 memory.

Constraints:
	offset: SmallInteger' .
%

category: 'Error Handling'
classmethod: CBuffer
_errorMallocFailed

"Raise an error because a call to malloc failed in the user action library."

self _error: #hostErrMemoryAlloc args: #()
%

category: 'Testing'
classmethod: CBuffer
_isBufferAvailable

"Return whether there is a buffer available that can be allocated."

^ true
%
category: 'Constants'
classmethod: CBuffer
_numAvailableBuffers

"Return the number of available buffers that can allocated on the heap."

^ 1
%

category: 'Instance Creation'
classmethod: CBuffer
new
"create an instance registered with VM for finalization of cData"

<primitive: 674>
self _primitiveFailed: #new
%
classmethod: CBuffer
new: size

"Create a new instance and allocate the given number of bytes in the heap."

| newOne status |
newOne := self new initialize.
status := newOne allocate: size.

status == 1 ifTrue: [^newOne].
status == 0 ifTrue: [ self _errorMallocFailed ].

^ self _halt: 'Unknown error when allocating CBuffer:' , status asString
%
! ------------------- Instance methods for CBuffer
category: 'Primitives'
method: CBuffer
_oneArgPrim: opcode arg: arg

"Execute the one arg primitive according to the given opcodes.
	0 = allocate:
	1 = setObjId:
	2 = setOclass: 
	3 = setObjectSecurityPolicyId:    
	4 = setIsInvariant: 
	5 = setNamedSize: 
	6 = setObjSize: 
	7 = setIdxSize: 
	8 = setValueBuffSize: 
	9 = setFirstOffset: 
	10 = setFormat: 
	11 = incrementActualBufferSize: 
	12 = getByteObjectInto: 
	13 = copyObjectReportInto: 
	14 = valueBufferPutOverlayAt:
	15 = setComplete:
        26 = setByteSwizzle:
"

<primitive: 198>
self _primitiveFailed: #_oneArgPrim:arg: args: { opcode . arg }.
self _uncontinuableError
%
category: 'Primitives'
method: CBuffer
_twoArgPrim: opcode arg: arg1 arg: arg2

"Execute the two arg primitive according to the given opcodes.
	0 = setBytes:startingAt:
	1 = valueBufferAt:put: 
"

<primitive: 199>
self _primitiveFailed: #_twoArgPrim:arg:arg: args: { opcode . arg1 . arg2 }.
self _uncontinuableError
%
category: 'Primitives'
method: CBuffer
_zeroArgPrim: opcode

"Execute the zero arg primitive according to the given opcodes.

	0 = allocatedSize
	1 = free
	2 = complete
	3 = objId
	4 = oclass
	5 = objectSecurityPolicy (obsolete)
	6 = currentObjectIsInvariant 
	7 = namedSize
	8 = objSize 
	9 = idxSize 
	10 = valueBuffSize 
	11 = firstOffset 
	12 = currentObjectIsSpecial 
	13 = currentObjectIsOop 
	14 = currentObjectIsByte 
	15 = currentObjectIsNsc 
	16 = actualBufferSize 
	17 = nextObjectReport 
	18 = setNextObjectReport 
	19 = setFirstObjectReport 
	20 = nextValueBufferOop 
	21 = getByteObject 
	22 = initTraversalBuffer 
	23 = objectReportHeaderSize
	24 = bytesToEnd 
	26 = isPartial
	27 = setNextObjectReport
	29 = advanceValueBufferOop
	30 = currentValueBufferOopIsSpecial
	31 = valueBufferSpecialOop
"

<primitive: 197>
self _primitiveFailed: #_zeroArgPrim: args: { opcode }.
self _uncontinuableError
%
! fixed 42487 
category: 'Allocation'
method: CBuffer
allocate: size

"
 Frees receiver's previous C memory if any.
 Allocate C heap memory and set the receiver to point to it.  
 Return a SmallInteger which indicates the status of the allocation:

-1 = not enought C buffers
0 = malloc failed
1 = allocation succeeded
"

^ self _oneArgPrim: 0 arg: size.
%
category: 'Allocation'
method: CBuffer
allocatedSize

"Return the amount of heap memory allocated, in bytes."

^ self _zeroArgPrim: 0.
%
! fixed 42487 
category: 'Allocation'
method: CBuffer
free

"Free previously allocated C heap memory.
 The memory will also be freed automatically if the
 instance is garbage collected by in-memory GC, or 
 is committed and faults out of temporary object memory."

^ self _zeroArgPrim: 1.
%
category: 'Initialization'
method: CBuffer
initialize

"Initialize a new instance."

%

