!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!
! $Id: setpathterm.gs 31614 2013-10-09 17:47:16Z dhenrich $
!
! classes created in idxclasses.topaz
!=========================================================================

expectvalue %Boolean
doit
BtreeComparisonForUnicodeCompare comment:
'BtreeComparisonForUnicodeCompare is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from BtreeComparisonForUnicodeCompare
removeallmethods BtreeComparisonForUnicodeCompare
removeallclassmethods BtreeComparisonForUnicodeCompare

! ------------------- Class methods for BtreeComparisonForUnicodeCompare
! ------------------- Instance methods for BtreeComparisonForUnicodeCompare
category: 'initialization'
set compile_env: 0
method: BtreeComparisonForUnicodeCompare
collator: anIcuCollator
  collator := anIcuCollator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeCompare
compareKey: aKey equalTo: aValue
  ^ aKey _idxForCompareEqualTo: aValue collator: collator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeCompare
compareKey: aKey greaterThan: aValue
  ^ aKey _idxForCompareGreaterThan: aValue collator: collator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeCompare
compareKey: aKey greaterThanOrEqualTo: aValue
  ^ aKey _idxForCompareGreaterThanOrEqualTo: aValue collator: collator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeCompare
compareKey: aKey lessThan: aValue
  ^ aKey _idxForCompareLessThan: aValue collator: collator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeCompare
compareKey: aKey lessThanOrEqualTo: aValue
  ^ aKey _idxForCompareLessThanOrEqualTo: aValue collator: collator
%
category: 'Testing'
set compile_env: 0
method: BtreeComparisonForUnicodeCompare
satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2
  ^ ((val1 _idxForCompareGreaterThan: val2 collator: collator)
    or: [ 
      (val1 _idxForCompareEqualTo: val2 collator: collator)
        and: [ (bool1 and: [ bool2 ]) not ] ])
    not
%

expectvalue %Boolean
doit
BtreeComparisonForUnicodeSort comment:
'BtreeComparisonForUnicodeSort is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from BtreeComparisonForUnicodeSort
removeallmethods BtreeComparisonForUnicodeSort
removeallclassmethods BtreeComparisonForUnicodeSort

! ------------------- Class methods for BtreeComparisonForUnicodeSort
! ------------------- Instance methods for BtreeComparisonForUnicodeSort
category: 'initialization'
set compile_env: 0
method: BtreeComparisonForUnicodeSort
collator: anIcuCollator
  collator := anIcuCollator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeSort
compareKey: aKey equalTo: aValue
  ^ aKey _idxForSortEqualTo: aValue collator: collator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeSort
compareKey: aKey greaterThan: aValue
  ^ aKey _idxForSortGreaterThan: aValue collator: collator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeSort
compareKey: aKey greaterThanOrEqualTo: aValue
  ^ aKey _idxForSortGreaterThanOrEqualTo: aValue collator: collator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeSort
compareKey: aKey lessThan: aValue
  ^ aKey _idxForSortLessThan: aValue collator: collator
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForUnicodeSort
compareKey: aKey lessThanOrEqualTo: aValue
  ^ aKey _idxForSortLessThanOrEqualTo: aValue collator: collator
%
category: 'Testing'
set compile_env: 0
method: BtreeComparisonForUnicodeSort
satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2
  ^ ((val1 _idxForCompareGreaterThan: val2 collator: collator)
    or: [ 
      (val1 _idxForSortEqualTo: val2 collator: collator)
        and: [ (bool1 and: [ bool2 ]) not ] ])
    not
%
