!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   Association, Object.
!
!=========================================================================

removeallmethods Association
removeallclassmethods Association

category: 'For Documentation Installation only'
classmethod: Association
installDocumentation

self comment:
'An Association is a pair of associated objects: a key and a value.  A
 Dictionary is a collection of Associations; thus, much of the protocol that
 affects Associations is actually defined for instances of Dictionary.  See the
 description of Dictionary for details.
--- instVar key
An object, usually used as a reference to its value.
--- instVar value
Another object, referenced by its key.
'.
%

category: 'Instance Creation'
classmethod: Association
newWithKey: aKey value: aValue

"Returns a new Association with the argument aKey as its key and with aValue as
 its value."

^ super new key: aKey value: aValue
%
category: 'Indexing Support'
method: Association
_idxValue

	^self value
%

category: 'Accessing'
method: Association
key

"Returns the value of the receiver's key."

^key
%

category: 'Accessing'
method: Association
value

"Returns the value portion of the receiver."

^value
%
category: 'Accessing'
method: Association
_value

" Returns the value portion of the receiver.
  Faster than #value  in Gs64 v3.0 since send of #value 
  assumes ExecBlock is most likely receiver. "

^value
%

category: 'Updating'
method: Association
key: aKey

"Sets the object aKey as the key of the receiver."

key := aKey
%

category: 'Updating'
method: Association
key: aKey value: aValue

"Sets the object aKey as the key of the receiver, and the object aValue as the
 value of the receiver."

key := aKey.
value := aValue
%

category: 'Updating'
method: Association
value: aValue

"Sets the object aValue as the value of the receiver."

value := aValue
%
method: Association
_value: aValue

" Updates the value portion of the receiver.
  Faster than #value:  in Gs64 v3.0 since send of #value: 
  assumes ExecBlock is most likely receiver. "

value := aValue
%

category: 'Clustering'
method: Association
clusterDepthFirst

"This method clusters the receiver, its key, and its value in
 depth-first order.  It returns true if the receiver has already
 been clustered during the current transaction, false otherwise."

  self cluster
  ifTrue:
    [ ^ true ]
  ifFalse:
    [ key clusterDepthFirst.
      value clusterDepthFirst.
      ^ false
    ].
%

category: 'Comparing'
method: Association
= anObject

"Returns true if (a) the receiver and anObject are both kinds of Association, 
 (b) the receiver and anObject have equal keys and (c) the receiver and
 anObject have equal values.  Returns false otherwise."

(self == anObject) ifTrue: [^ true].
(anObject isKindOf: Association) ifFalse:[^ false].
^ (key = anObject key) and: [value = anObject value].
%

category: 'Comparing'
method: Association
~= anObject

"Returns true if one or more of the conditions specified in #= method are
 not satisfied.  Returns false otherwise."

^ (self = anObject) not.
%

category: 'Comparing'
method: Association
< anObject

"Returns true if the key of the receiver collates before anObject.
 Returns false otherwise."

^ key == self
  ifTrue: [ false ]
  ifFalse: [ anObject > self key ]
%

category: 'Comparing'
method: Association
<= anObject

"Returns true if the key of the receiver collates before anObject, or if the
 key of the receiver is equivalent to anObject.  Returns false otherwise."

^ key == self
  ifTrue: [ true ]
  ifFalse: [ anObject >= self key ]
%

category: 'Comparing'
method: Association
> anObject

"Returns true if the key of the receiver collates after anObject.
 Returns false otherwise."

^ anObject < self key
%

category: 'Comparing'
method: Association
>= anObject

"Returns true if the key of the receiver collates after anObject, or if the
 key of the receiver is equivalent to anObject.  Returns false otherwise."

^ anObject <= self key
%

category: 'Comparing'
method: Association
hash

"Returns an Integer hash code for the receiver."

^ key hash
%

category: 'Formatting'
set compile_env: 0
method: Association
isInPrintingRecursionSet: anIdentitySet
	"Answer whether we are recursing through the receiver.

	 For associations, there are pathological cases one can create,
	 that we have chosen to portray in their logical representation.
	 Since some dictionaries use associations and others do not,
	 portray the results as if they all do.

	 In addition to the fast identity check, include a slower equality check."

	^(super isInPrintingRecursionSet: anIdentitySet)
		or: [anIdentitySet includesValue: self]
%

category: 'Formatting'
set compile_env: 0
method: Association
printNonRecursiveRepresentationOn: aStream recursionSet: anIdentitySet
	"Put a displayable representation of the receiver on the given stream
	 while avoiding recursion from object reference loops."

	key printOn: aStream recursionSet: anIdentitySet.
	aStream nextPutAll: '->'.
	value printOn: aStream recursionSet: anIdentitySet
%

category: 'Formatting'
set compile_env: 0
method: Association
printOn: aStream
	"Put a displayable representation of the receiver on the given
	 stream. If the key or the value is identical to the receiver then
	 avoid an infinite recursion. (There is currently no general way to
	 limit these kinds of recursions. See Bug #16259)"

	self printNonRecursiveOn: aStream
%

category: 'Testing'
method: Association
isAssociation
  ^ true
%
