!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   AbstractSession, Object
!
!=========================================================================

! AbstractSession created in bom.c or exists from v2.x repository

removeallmethods  AbstractSession
removeallclassmethods  AbstractSession

category: 'For Documentation Installation only'
classmethod: AbstractSession
installDocumentation

self comment:
'AbstractSession is an abstract class for describing within GemStone sessions
 that exist either in GemStone or in some other server software.  It is
 intended to provide support in GemStone for two-phase commit protocols between
 transactions in related sessions.

 For example, a session external to GemStone could be a session in an external
 database.  It could be spawned by the current GemStone session.  The GemStone
 session object permits access to its symbol list for name resolution within its
 name space, enables execution of Smalltalk code within the session, and allows
 control of its transaction state.' .

%

category: 'Accessing'
method: AbstractSession
_publicName

"(Subclass responsibility.)  Returns a name to use for error messages."

AbstractSession subclassResponsibility: #_publicName
%

category: 'Commit Processing'
method: AbstractSession
_abort 

"(Subclass responsibility.)  Makes the remote session abort any changes to
 permanent state."

AbstractSession subclassResponsibility: #_abort
%

category: 'Commit Processing'
method: AbstractSession
_commit: commitMode

"(Subclass responsibility.)  Makes the remote session commit any changes to
 permanent state."

AbstractSession subclassResponsibility: #_commit:
%

category: 'Commit Processing'
method: AbstractSession
_voteToCommit 

"(Subclass responsibility.)  Returns a SmallInteger indicating the status
 of the vote.  The returned value has the following meaning:

 0: The session was read-only and the vote is affirmative.
 1: The session wrote objects and the vote is affirmative.
 2: The vote is negative; the session cannot commit."

AbstractSession subclassResponsibility: #_voteToCommit
%

category: 'Commit Processing'
method: AbstractSession
_isNonBlocking

"Return true if the synchronized commit algorithm may use non-blocking
 messages and false otherwise."

^ false
%

category: 'Commit Processing'
method: AbstractSession
_nbTimeout

"(Subclass responsibility.)  Returns a SmallInteger, indicating the minimum
 number of seconds that a non-blocking call will be allowed to execute before
 the coordinator considers the non-blocking call to have failed."

AbstractSession subclassResponsibility: #_nbTimeout
%

category: 'Commit Processing'
method: AbstractSession
_nbVoteToCommit

"(Subclass responsibility.)  Non-blocking voteToCommit."

self _isNonBlocking
  ifTrue: [ AbstractSession subclassResponsibility: #_nbVoteToCommit ]
%

category: 'Commit Processing'
method: AbstractSession
_nbVoteResult

"(Subclass responsibility.)  Gets the result of a non-blocking vote."

self _isNonBlocking
  ifTrue: [ AbstractSession subclassResponsibility: #_nbVoteResult ]
%

category: 'Commit Processing'
method: AbstractSession
_nbCommit: commitMode

"(Subclass responsibility.)  Non-blocking commit:"

self _isNonBlocking
  ifTrue: [ AbstractSession subclassResponsibility: #_nbCommit: ]
%

category: 'Commit Processing'
method: AbstractSession
_nbCommitResult

"(Subclass responsibility.)  Gets the result of a non-blocking commit."

self _isNonBlocking
  ifTrue: [ AbstractSession subclassResponsibility: #_nbCommitResult ]
%

category: 'Commit Processing'
method: AbstractSession
_nbAbort

"(Subclass responsibility.)  Non-blocking abort."

self _isNonBlocking
  ifTrue: [ AbstractSession subclassResponsibility: #_nbAbort ]
%

category: 'Commit Processing'
method: AbstractSession
_nbAbortResult

"(Subclass responsibility.)  Gets the result of a non-blocking abort."

self _isNonBlocking
  ifTrue: [ AbstractSession subclassResponsibility: #_nbAbortResult ]
%

category: 'Commit Processing'
method: AbstractSession
_nbCancel

"(Subclass responsibility.)  Cancel the execution of a non-blocking call."

self _isNonBlocking
  ifTrue: [ AbstractSession subclassResponsibility: #_nbCancel ]
%

category: 'Commit Processing'
method: AbstractSession
_nbEnd

"(Subclass responsibility.)  Determine the status of a non-blocking call."

self _isNonBlocking
  ifTrue: [ AbstractSession subclassResponsibility: #_nbEnd ]
%

category: 'Commit Processing'
method: AbstractSession
_beginTransaction

"Do nothing for now."

%

category: 'Commit Processing'
method: AbstractSession
_transactionMode: newMode

"Do nothing for now."

%

