!=========================================================================
! Copyright (C) GemTalk Systems 2006-2020.  All Rights Reserved.

! methods in class GsObjectSecurityPolicy that are disallowed 
! this file comes after conversion of old instances of GsObjectSecurityPolicy

set class GsObjectSecurityPolicy

! fixed 41565
category: 'Instance Creation'
classmethod
new

"Returns a new GsObjectSecurityPolicy in the Repository aRepository.  If the 
 maximum number of ObjectSecurityPolicies has already been created for aRepository, 
 this generates an error.
 The new GsObjectSecurityPolicy is owned by the UserProfile of the current session, 
 and has the default authorization of W----- (owner can read and write).  

 After execution of this method, the current transaction must be committed
 before objects can be created in the GsObjectSecurityPolicy, object assigned to 
 the objectSecurityPolicy, or the GsObjectSecurityPolicy used as argument to a 
 defaultObjectSecurityPolicy: keyword in 
 creation of UserProfiles.

 Requires the ObjectSecurityPolicyCreation privilege 
 and WriteAccess to DataCuratorObjectSecurityPolicy.
 "

^ self newInRepository: SystemRepository
%

category: 'Updating'
method
_objectSecurityPolicy: anObjectSecurityPolicy

"Disallowed"

self shouldNotImplement: #_objectSecurityPolicy: 
%

method
instVarAt: offset put: aValue
"Disallowed"
self shouldNotImplement: #instVarAt:put:
%

method
nilFields
"Disallowed"
self shouldNotImplement: #nilFields
%

method
_primitiveAt: offset put: aValue
"Disallowed"
self shouldNotImplement: #_primitiveAt:put:
%

category: 'Copying'
method
copy

"Disallowed."

self shouldNotImplement: #copy
%

category: 'Storing and Loading'

method
basicLoadFrom: passiveObj
"Disallowed."
self shouldNotImplement: #basicLoadFrom:
%

method
basicLoadFrom: passiveObj size: aSize
"Disallowed"
self shouldNotImplement: #basicLoadFrom:size:
%

method
basicLoadFromNoRead: passiveObj
"Disallowed"
self shouldNotImplement: #basicLoadFromNoRead:
%

method
basicLoadFromNoRead: passiveObj size: aSize
"Disallowed"
self shouldNotImplement: #basicLoadFromNoRead:size:
%

method
basicLoadFromOld: passiveObj
"Disallowed"
self shouldNotImplement: #basicLoadFromOld:
%

method
loadFrom: passiveObj
"Disallowed"
self shouldNotImplement: #loadFrom:
%

method
loadNamedIVsFrom: passiveObj
"Disallowed"
self shouldNotImplement: #loadNamedIVsFrom:
%

method
loadVaryingFrom: passiveObj
"Disallowed"
self shouldNotImplement: #loadVaryingFrom:
%

method
loadVaryingFrom: passiveObj size: aSize
"Disallowed"
self shouldNotImplement: #loadVaryingFrom:size:
%

category: 'Instance migration'

method
become: anObj
"Disallowed"
self shouldNotImplement: #become:
%

method
_primitiveBecome: anObject forDict: aBoolean
"Disallowed"
self shouldNotImplement: #_primitiveBecome:forDict:
%

method
migrate
"Disallowed" 
self shouldNotImplement: #migrate
%

method
migrateFrom: anObj
"Disallowed" 
self shouldNotImplement: #migrateFrom:
%

method
migrateFrom: anObj instVarMap: aDict
"Disallowed"
self shouldNotImplement: #migrateFrom:instVarMap:
%

method
migrateIndexable: anObj myClass: aCls otherClass: secondCls
"Disallowed"
self shouldNotImplement: #migrateIndexable:myClass:otherClass:
%

method
changeClassTo: aCls
"Disallowed"
self shouldNotImplement: #changeClassTo:
%

