!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

removeallmethods GsExceptionHandler
removeallclassmethods GsExceptionHandler

set class GsExceptionHandler

category: 'Documentation'
classmethod:
comment
^
'Instances of GsExceptionHandler represent legacy Gemstone exception 
 handlers or ANSI default (i.e. static) handlers.  
 Legacy handlers are created by 
   Exception(C)>>category:number:do: 
   Exception(C)>>installStaticException:category:number:subtype:
   Exception(C)>>addDefaultHandler:  
 ANSI default handlers are created by 
   Exception(C)>>addDefaultHandler:   
 Subclasses of GsExceptionHandler are disallowed. 

Constraints:
	next: GsExceptionHandler
	exClass: AbstractException
	number: SmallInteger
	theBlock: ExecBlock
	subtype: Object'
%

category: 'Disallowed'
classmethod:
new
  "instances may be created only by using
     Exception(C)>>category:number:do:
     Exception(C)>>installStaticException:category:number:
     Exception(C)>>installStaticException:category:number:subtype:
     Exception(C)>>addDefaultHandler:
  "
  self shouldNotImplement: #new .
  ^ nil
%
classmethod:
basicNew
  "Instances are created only by methods in Exception. See also #new ."

  self shouldNotImplement: #basicNew .
  ^ nil
%

category: 'Accessing'
method:
subtype

"Returns the value of the receiver's subtype instance variable."

^subtype
%
category: 'Accessing'
method:
next

"Returns the next exception to be invoked (the value of the next instance
 variable)."

^next
%
method:
exceptionClass
  ^ exClass
%
method:
isLegacy
  ^ exClass == nil
%
category: 'Accessing'
method:
category

^ GemStoneError
%

category: 'Accessing'
method:
number

"Returns the value of the instance variable 'number'."

^number
%

category: 'Accessing'
method:
block

"Returns the value of the instance variable 'theBlock'."

^ theBlock
%

method:
_ansiBlock
  "If receiver is an ANSI static handler, return the receivers block,
   else return nil." 
  exClass ifNotNil:[ ^ theBlock ].
  ^ nil
%

category: 'Management'
method:
_remove

"Search the current GemStone Smalltalk call stack for a method or block context
 that has the receiver installed, and remove it.  The stack is searched by
 starting with the top method or block context and moving down.  

 Returns receiver if found, nil if not found ."

<primitive: 375>
self _primitiveFailed: #remove
%

method:
remove
"Search the current GemStone Smalltalk call stack for a frame
 that has the receiver installed, and remove it if found.
 If not found on the stack, search the list of static handlers and
 remove it if found.

 Returns receiver if found, nil if not found ."
 
  ^ self _remove ifNil:[ AbstractException removeStaticException: self ]
% 

classmethod:
removeActivationException: aGsExceptionHandler

"Search the current GemStone Smalltalk call stack for a method or block context
 that has anException installed, and remove it.  The stack is searched by
 starting with the top method or block context and moving down.  

 If aGsExceptionHandler was found on the stack, returns aGsExceptionHandler,
 otherwise signals a RuntimeError.  "

aGsExceptionHandler class == GsExceptionHandler ifTrue:[
  aGsExceptionHandler _remove ifNil:[
    LookupError signal: 'aGsExceptionHandler was not found on the stack'
  ].
  ^ aGsExceptionHandler .
].
aGsExceptionHandler _validateClass: GsExceptionHandler 
%

