!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

set class ExceptionSet

removeallmethods 
removeallclassmethods 

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'This protocol describes the behavior of objects that may be 
used to group a set of <exceptionSelector> objects into a 
single <exceptionSelector>. This is useful for establishing 
a single exception handler that may deal with several different 
types of exceptions.

Subclasses are disallowed .

Instances conform to exceptionSelector and Object.'.
%

category: 'instance creation'
classmethod:
with: selector1 with: selector2
  "Private - Answer a new instance of the receiver containing 
  the <exceptionSelector> arguments, selector1 and selector2"

  | res |
  res := self new .
  res , selector1 .
  res , selector2 .
  ^ res
%

category: 'ANSI - exceptionSelector'
method:
, anotherExceptionOrSet
  "Return an exception set that contains all of the exception selectors in both
  the receiver and the argument.
  This is commonly used to specify a set of exception selectors for an 
  'exception handler.'

  The argument must be a subclass of Exception or a kind of ExceptionSet .
  Returns the receiver."

  anotherExceptionOrSet _isExceptionClass ifTrue:[
    self at: self size + 1 put: anotherExceptionOrSet  . "inline self add:"
    ^ self
  ].
  (anotherExceptionOrSet isKindOf: ExceptionSet) ifTrue:[ | sz |
    sz := self size .
    1 to: anotherExceptionOrSet size do:[:j | 
      "inline self add: "
      sz := sz + 1 .
      self at: sz put: (anotherExceptionOrSet at:j)
    ].
  ].
  anotherExceptionOrSet _validateClass: ExceptionSet.
%

category: 'ANSI support'
method:
add: anException

 ^self at: self size + 1 put: anException 
%

category: 'ANSI support'
method:
at: anOffset put: anException

 anException _isExceptionClass ifFalse:[
   anException _error: #rtErrBadArgKind args: { Error }.
   self _uncontinuableError .
 ].
 ^ super at: anOffset put: anException 
%

category: 'ANSI - exceptionSelector'
method:
handles: anExceptionClass

  1 to: self size do:[:j | 
    ((self at: j) handles: anExceptionClass) ifTrue:[ ^ true ] .
  ].
  ^ false
%

category: 'initializing'
method:
initialize

  ^ self
%

category: 'accessing'
method:
selectors
  "Return the list of Exceptions contained in the receiver."
  | res |
  res := OrderedCollection new: self size .
  1 to: self size do:[:j | 
    res at: j put: (self at: j) .
  ].
  ^ res
%

category: 'Exceptions'
method:
selectors: anOrderedCollection
  "Store all elements of anOrderedCollection into receiver's varying instVars,
   growing or shrinking receiver to match size of anOrderedCollection."

  self size: anOrderedCollection size .
  1 to: anOrderedCollection size do:[:j |
    self at: j put: (anOrderedCollection at:j)
  ].
%

! size inherited


