!=========================================================================
! Copyright (C) GemTalk Systems 1991-2020.  All Rights Reserved
!
! file AppendableString.gs 
!=========================================================================

expectvalue %String
run
(Symbol _existingWithAll:'StringAppendStream') ifNotNil:[  | cls |
  "upgrade from 3.4 alpha"
  cls := Globals at: 'StringAppendStream' asSymbol otherwise: nil .
  cls ifNotNil:[ 
    cls _unsafeAt: 11 put: #AppendableString .  
    Globals at: #AppendableString put: cls .
    ^ 'renamed StringAppendStream to AppendableString'
  ].
].
^ String _newKernelSubclass: 'AppendableString'
        instVarNames:#()
        classVars: #()
        classInstVars: #()
        poolDictionaries: #()
        inDictionary: Globals
        options: #() reservedOop: nil .
%
set class AppendableString
removeallmethods 
removeallclassmethods 

category: 'For Documentation Installation only'
classmethod:
installDocumentation
self comment:
'AppendableString is intended for streams that are are created empty,  
appended to , and then the contents are retrieved for writing to a socket.
There is no stream-specific support for reading, write limit, nor 
position logic.
Takes advantage of the fact that Strings in GemStone are variable size. 

Instance creation is inherited from   String class >> new .

The contents of a AppendableString are 
Characters with codePoints in range 0 to 255, or UTF8 encoded data .
Attempts to append codePoints above 255 with nextPut methods 
will signal an error.'
%

category: 'Instance Creation'
classmethod:
new: aSize
  "Disallowed,  use the inherited   String class >> new ."
  self shouldNotImplement: #new: 
%

category: 'Adding'
method:
nextPut: aCharacterOrString
  <primitive: 296>
  ^ self nextPutAll: aCharacterOrString
%

! fix 47129
method:
add: aCharacterOrString
  <primitive: 296>
  ^ self nextPutAll: aCharacterOrString
%
method:
addLast: aCharacterOrString
  <primitive: 296>
  ^ self nextPutAll: aCharacterOrString
%
method:
addAll: aString
  <primitive: 296>
  ^ self nextPutAll: aString
%

category: 'Adding'
method:
nextPutAll: aCharacterOrString
  <primitive: 296>
  aCharacterOrString class == Character ifTrue:[
    aCharacterOrString codePoint > 255 ifTrue:[
      ArgumentError signal:'codePoint exceeds 255'.
    ].
  ].
  aCharacterOrString stringCharSize == 1 ifFalse:[
    aCharacterOrString _validateKindOfClass: String .
  ].
  ^ self _primitiveFailed: #nextPutAll: args: { aCharacterOrString }.
%
category: 'Adding'
method:
nextPutCodePoint: aSmallInteger
  <primitive: 1047>
  ^ self nextPut: (Character codePoint: aSmallInteger).
%
method:
addCodePoint: aSmallInteger
  <primitive: 1047>
  ^ self nextPut: (Character codePoint: aSmallInteger).
%

category: 'Encoding'
method: 
nextPutAllUtf8: aCharacterOrString
 "Appends the UTF8 encoding of the argument to receiver"
 <primitive: 1045>
  aCharacterOrString _validateKindOfClasses: { Character . String } .
  ^ self _primitiveFailed: #nextPutAllUtf8: args: { aCharacterOrString }
%

category: 'Accessing'
method:
contents
  ^ self
%

category: 'Updating'
method:
size: anInteger

anInteger == 0 ifFalse:[  
  Error signal:' size: should only be used to reset a stream to empty'
].
^super size: anInteger
%

category: 'Character writing'
method:
cr
  self addCodePoint: 13
%
method:
crlf
  self addCodePoint: 13 ; addCodePoint: 10 
%
method:
crtab
  self addCodePoint: 13 ; addCodePoint: 9 
%
method:
space
  self addCodePoint: 32
%
method:
tab
  self addCodePoint: 9
%
method:
tab: anInteger
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [self tab]
%
method:
space: anInteger
  "Append anInteger space characters to the receiver."

  anInteger timesRepeat: [ self addCodePoint: 32 ]
%
method:
crtab: anInteger
  "Append a return character, followed by anInteger tab characters, to the
  receiver."

  self addCodePoint: 13 .
  anInteger timesRepeat: [ self addCodePoint: 9 ]
%

! fixed 47110
category: 'Storing and Loading'
classmethod:
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

inst := self basicNew: passiveObj readSize.
inst loadFrom: passiveObj.
^inst
%

! fix 47129
category: 'Updating'
method:
at: anIndex put: aChar

anIndex == (self size + 1) ifTrue:[
  ^ self add: aChar .
].
^ self _errorIndexOutOfRange: anIndex
%

method:
codePointAt: anIndex put: aSmallInteger

anIndex == (self size + 1) ifTrue:[
  ^ self addCodePoint: aSmallInteger .
].
^ self _errorIndexOutOfRange: anIndex
%

method:
insertAll: aCharOrCharColl at: anIndex

anIndex == (self size + 1) ifTrue:[
  ^ self addAll: aCharOrCharColl
].
^ self _errorIndexOutOfRange: anIndex
%

method:
removeFrom: startIndex to: stopIndex

"Disallowed"
  self shouldNotImplement: #removeFrom:to: 
%

! replaceFrom: startIndex to: stopIndex with: charCollection startingAt: repIndex
!   needed by loadFrom:

method:
_reverseFrom: aString
"Disallowed"
  self shouldNotImplement: #_reverseFrom:
%

