!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ObsoleteIdentityDictionary, ObsoleteDictionary, IdentitySet, 
!   IdentityBag, UnorderedCollection, Collection, Object.
!
!=========================================================================

removeallmethods ObsoleteIdentityDictionary
removeallclassmethods ObsoleteIdentityDictionary

category: 'For Documentation Installation only'
classmethod: ObsoleteIdentityDictionary
installDocumentation

self comment:
'The class ObsoleteIdentityDictionary is obsolete; existing instances should 
be migrated to IdentityDictionary or otherwise processed as required.'
%

category: 'Removing'
method: ObsoleteIdentityDictionary
removeKey: aKey ifAbsent: aBlock

"Removes the Association with key aKey from the receiver and returns the value
 of that Association.  If no Association is present with key aKey, this method
 evaluates the zero-argument block aBlock and returns the result of that
 evaluation."

|assn|

assn := self associationAt: aKey ifAbsent: [^aBlock value].
self removeAssociation: assn.
^assn value
%

category: 'Accessing'
method: ObsoleteIdentityDictionary
associationAt: aKey ifAbsent: aBlock

"Returns the Association with key aKey.  Comparison is based on identity, not
 equality.  If no such Association exists, returns the result of evaluating the
 zero-argument block aBlock."

^self _detect: {:x | x.key == aKey} ifNone: [aBlock value]
%

category: 'Accessing'
method: ObsoleteIdentityDictionary
at: aKey

"Returns the value of the Association with key aKey.  Comparison is based on
 identity, not equality.  Generates an error if no such Association exists."

| theAssoc |
theAssoc := self _detect: {:x | x.key == aKey}
                  ifNone: [ theAssoc := self _errorKeyNotFound: aKey] .
^ theAssoc value
%

category: 'Accessing'
method: ObsoleteIdentityDictionary
at: aKey ifAbsent: aBlock

"Returns the value of the Association with key aKey.  Comparison is based on
 identity, not equality.  If no such Association exists, returns the result of
 evaluating the zero-argument block aBlock."

self size = 0 ifTrue: [^aBlock value].
^(self associationAt: aKey ifAbsent: [^aBlock value]) value
%

category: 'Updating'
method: ObsoleteIdentityDictionary
at: aKey put: aValue

"Creates a new Association with the given key and value and adds it to the
 receiver.  If the receiver already contains an Association with the given key,
 this makes aValue the value of that Association.  Returns aValue."

| assn |
assn := self associationAt: aKey ifAbsent: [nil].
assn == nil ifTrue: [
  super _basicAdd:
    ((Association) new key: aKey value: aValue)
  ]
ifFalse: [
  assn value: aValue
  ].
^aValue
%

category: 'Searching'
method: ObsoleteIdentityDictionary
includesKey: aKey

"Returns true if the receiver contains an Association whose key is aKey.
 Returns false otherwise."

^ (self associationAt: aKey otherwise: nil ) ~~ nil
%

category: 'Accessing'
method: ObsoleteIdentityDictionary
at: aKey otherwise: aValue

"Returns the value of the Association with key aKey.  If no such Association
 exists, returns the given value."

| sz anAssoc |
sz := self size.
sz = 0 ifTrue: [ ^aValue ].

1 to: sz do: [ :j |
  anAssoc := self _at: j.
  aKey == anAssoc key ifTrue: [ ^anAssoc value ]
].
^aValue
%
category: 'Storing and Loading'
classmethod: ObsoleteIdentityDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: IdentityDictionary
%

category: 'Repository Conversion'
method: ObsoleteIdentityDictionary
rehashForConversion

    "Replace the 5.1.2 version of this method. This version will cause
    the receiver to become an IdentityKeyValueDictionary rather than
    an IdentityDictionary. The new choice is more efficient and is the
    class that is mapped to VW's IdentityDictionary."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[
  | newDict |
  self class == ObsoleteIdentityDictionary ifFalse:[
    ^self
  ].
  newDict := IdentityKeyValueDictionary new: self size.
  newDict objectSecurityPolicy: self objectSecurityPolicy.
  self keysAndValuesDo: [ :key :value |
       newDict at: key put: value
  ].
  newDict _becomeDictionary: self.
] ensure:[
  prot _leaveProtectedMode
]
%

category: 'Repository Conversion'
classmethod: ObsoleteIdentityDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteIdentityDictionary)
  ifTrue: [ ^ IdentityDictionary ].

^ self.
%

