!=========================================================================
! Copyright (C) GemTalk Systems 2010-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

set class ObsoleteException
removeallmethods
removeallclassmethods

category: 'Documentation'
classmethod: 
comment
^ '
 Instances of ObsoleteException are committed instances of the
 class which was named Exception in Gs64 v2.x .
 They are not usable by the Gs64 v3.0 VM .
 and would usually be referenced by committed instances of ObsoleteGsProcess.
 Instance creation is disallowed. 

 The Gs64 v2.x class named ExceptionA, if present, has been
 renamed to ObsoleteExceptionA and is also not usable by the Gs64 v3.0 VM.
'
%

category: 'Instance creation'
classmethod: 
new
  self shouldNotImplement: #new
%
classmethod: 
new: aSize
  self shouldNotImplement: #new:
%
category: 'Instance creation'
classmethod: 
_basicNew
  self shouldNotImplement: #_basicNew
%
classmethod: 
_basicNew: aSize
  self shouldNotImplement: #_basicNew: 
%

