!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   NscBuilder, Array, SequenceableCollection, Collection, Object.
!
!=========================================================================

! Create the class NscBuilder, if it does not already exist

expectvalue %String
run
Array _newKernelSubclass: #NscBuilder
  instVarNames: #(#nsc #counter #finalResult )
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #() 
  reservedOop: 843
%

!========================================================================
! remove all methods

removeallmethods NscBuilder
removeallclassmethods NscBuilder

! ------------------- Class methods for NscBuilder
category: 'For Documentation Installation only'
classmethod: NscBuilder
installDocumentation

self comment:

'NscBuilder should only be used for transient objects.  They are not
completely logged by the transaction logging subsystem!

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	nsc: IdentityBag
	counter: SmallInteger
	finalResult: UnorderedCollection' .

%

category: 'Constants'
classmethod: NscBuilder
maxSize

"Returns the maximum size of the root object for efficient implementation."

^ 2000
%

category: 'Instance Creation'
classmethod: NscBuilder
for: aBag max: aSize

"Create an initialized instance of the receiver."

| res |
res := super new: (self maxSize min: aSize).
res counter: 0 ; finalResult: aBag .
(aBag isKindOf: IdentityBag) 
  ifTrue:[ res nsc: aBag ]
  ifFalse:[ res nsc: IdentityBag new "handle equality Bag, Set" ].
^ res
%

category: 'Instance Creation'
classmethod: NscBuilder
new

"Create a NscBuilder with the 'for:' message."

self shouldNotImplement: #new
%

! ------------------- Instance methods for NscBuilder
category: 'Adding'
method: NscBuilder
add: anObject

"Add the object to the receiver.  If the receiver is full, add all of
 its contents to the NSC and reset the counter."

<primitive: 326>
self _primitiveFailed: #add: args: { anObject } .
self _uncontinuableError
%

category: 'Accessing'
method: NscBuilder
_completeNsc

"Returns the NSC with all elements of the receiver added to it."

<primitive: 163>
self _primitiveFailed: #completeNsc .
self _uncontinuableError
%

category: 'Accessing'
method: NscBuilder
completeBag

"Returns the complete result object."

| nscRes finalRes |
nscRes := self _completeNsc .
nscRes == finalResult ifFalse:[
  "handle equality Bag, Set"
  finalRes := finalResult .
  1 to: nscRes size do:[ :j | finalRes add: (nscRes _at: j) ] .
				"deleted   'reduce garbage' code"
  ^ finalRes .
  ].
^ nscRes
%

category: 'Updating'
method: NscBuilder
nsc: newValue

"Modify the value of the instance variable 'nsc'."

nsc := newValue
%

category: 'Updating'
method: NscBuilder
finalResult: newValue

"Modify the value of the instance variable 'finalResult'."

finalResult := newValue
%

category: 'Updating'
method: NscBuilder
counter: newValue

"Modify the value of the instance variable 'counter'."

counter := newValue
%

category: 'Adding'
method: NscBuilder
addAll: aCollection

"Adds all of the elements of aCollection to the receiver and returns the
 receiver."

(self == aCollection)
    ifTrue: [ ^ self addAll: aCollection copy ].
self _addAll: aCollection.
^ self
%

category: 'Adding'
method: NscBuilder
_addAll: aCollection

"Adds all of the elements of aCollection to the receiver.  If aCollection is
 an Array or a subclass of IdentityBag, then the elements of the collection are 
 added without faulting them in, otherwise the elements are added individually." 

<primitive: 58>
(self == aCollection) ifTrue: [ ^ self addAll: (aCollection copy) ].
aCollection _validateClass: Collection.
aCollection accompaniedBy: self do: [:me :each | me add: each].
^ aCollection
%

category: 'Adding'
method: NscBuilder
_addAllNsc: aBag

"Adds all of the elements of aBag to the receiver and returns the receiver."

^ self _addAll: aBag
%

category: 'Adding'
method: NscBuilder
addLast: newObject

""

self shouldNotImplement: #addLast:
%

category: 'Adding'
method: NscBuilder
insertAll: aSequenceableCollection at: anIndex

""

self shouldNotImplement: #insertAll:at:
%

category: 'Updating'
method: NscBuilder
first: obj

""

self shouldNotImplement: #first:
%

category: 'Updating'
method: NscBuilder
last: obj

""

self shouldNotImplement: #last:
%

category: 'Updating'
method: NscBuilder
at: anIndex put: aValue

""

self shouldNotImplement: #at:put:
%

category: 'Updating'
method: NscBuilder
size: anInteger

""

self shouldNotImplement: #size:
%

category: 'Removing'
method: NscBuilder
removeFrom: startIndex to: stopIndex

""

self shouldNotImplement: #removeFrom:to:
%

category: 'Updating'
method: NscBuilder
_resetForAudit

self counter: 0.
nsc removeAll: nsc.
(nsc ~~ finalResult) 
  ifTrue: [ finalResult removeAll: finalResult ].
%
category: 'Indexing Support'
classmethod: NscBuilder
_canCreateQueryOnInstances
  "Cannot create a GsQuery on the receiver"

  ^ false
%
