!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!    LanguageDictionary, SymbolDictionary, IdentityDictionary,
!    IdentityKeyValueDictionary, KeyValueDictionary, AbstractDictionary,
!    Collection, Object
!
!=========================================================================

removeallmethods LanguageDictionary
removeallclassmethods LanguageDictionary

category: 'For Documentation Installation only'
classmethod: LanguageDictionary
installDocumentation

self comment:
'A LanguageDictionary is a SymbolDictionary designed to hold language-dependent
 objects.  Language symbols are used as keys, so that a user''s language symbol
 (see UserProfile | nativeLanguage) can be used to find the appropriate object
 for the native language.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger' .
%

category: 'Accessing'
method: LanguageDictionary
value

"Returns the value associated with the user's native language Symbol.  That
 Symbol is taken from the user's UserProfile object.  If there is no entry for
 the given language, an error is generated."

|myLanguage "the Symbol representing the user's native language"|

myLanguage := System myUserProfile nativeLanguage.
^ self at: myLanguage
       ifAbsent: [^ self _errorKeyNotFound: myLanguage]
%

