! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id$
!
! ========================================================================

expectvalue %String
run
^ Object _newKernelSubclass: #GemStoneParameters
  instVarNames: #(#gemStoneName #username #password
		#hostUsername #hostPassword #gemService)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #()
  reservedOop: 919
%

! Remove existing behavior from GemStoneParameters
removeallmethods GemStoneParameters
removeallclassmethods GemStoneParameters

! ------------------- Class methods for GemStoneParameters
classmethod:
comment
^'GemStoneParameters is used by the class GciInterface.
Instances are used as arguments to the login methods in
GciInterface.

Constraints:
	gemStoneName: String
	username: String
	password: String
	hostUsername: String
	hostPassword: String
	gemService: String'
%

classmethod: GemStoneParameters
new

"Create a new initialized instance."

^ self basicNew initialize.
%

! ------------------- Instance methods for GemStoneParameters
method: GemStoneParameters
initialize

"Initialize the instance variables of the receiver."
  ^ self setLoginWithPassword 
%

category: 'Updating'
method: GemStoneParameters
_encrypt: aString

"Return a new, encrypted string from the given string. ."

^ self _oneArgPrim: 24 with: aString
%
category: 'Error Handling'
method: GemStoneParameters
_errorBadPassword

"Raise an error because could encrypt and store a password."

self _error: #rtErrPasswordNotVariant args: #()
%
category: 'Private'
method: GemStoneParameters
_getArg: ivOffset key: key

"Obsolete method"


<protected primitive: 485>

^ nil
%
category: 'Private'
method: GemStoneParameters
_secureArg: ivOffset key: key

"Obsolete method"


<protected primitive: 490>

^ nil
%
category: 'Private'
method: GemStoneParameters
_zeroArgPrim: opcode

"Primitive dispatch.  Legal values:
    40: GemStoneParameters | _securePasswords
"

<primitive: 197>

^self _primitiveFailed: #_zeroArgPrim: args: { opcode }
%
method: GemStoneParameters
_oneArgPrim: opcode with: arg

"Primitive dispatch. Legal values:
    24 GemStoneParameters | _encrypt:
"

<primitive: 198>

^self _primitiveFailed: #_oneArgPrim: args: { opcode . arg }
%
method: GemStoneParameters
_securePasswords
"Do not allow anyone to read passwords."

| result |

result := self _zeroArgPrim: 40.
^ result
%
category: 'Accessing'
method: GemStoneParameters
gemService

   "Return the value of the instance variable 'gemService'."
   ^gemService
%
category: 'Updating'
method: GemStoneParameters
gemService: newValue

   "Modify the value of the instance variable 'gemService'."
   newValue _isOneByteString ifFalse:[ newValue _validateClass: String ].
   gemService := newValue
%
category: 'Accessing'
method: GemStoneParameters
gemStoneName

   "Return the value of the instance variable 'gemStoneName'."

^ gemStoneName
%
category: 'Updating'
method: GemStoneParameters
gemStoneName: aName

"Set the gemStone name. aName must be nil(meaning use server name
of the current session) or aString. "

aName ifNotNil:[
  aName _isOneByteString ifFalse:[ aName _validateClass: String ].
].
gemStoneName := aName.
%
category: 'Accessing'
method: GemStoneParameters
hostPassword

   "Return the value of the instance variable 'hostPassword'."
   ^hostPassword
%
category: 'Updating'
method: GemStoneParameters
hostPassword: pword

"Set the host password for the receiver.  The password is encrypted.
The given password's size is set to zero."

pword _isOneByteString ifFalse:[ pword _validateClass: String ].
hostPassword := self _encrypt: pword.
hostPassword immediateInvariant.
self _securePasswords.

pword size: 0.
^ pword
%
category: 'Accessing'
method: GemStoneParameters
hostUsername

   "Return the value of the instance variable 'hostUsername'."
   ^hostUsername
%
category: 'Updating'
method: GemStoneParameters
hostUsername: newValue

   "Modify the value of the instance variable 'hostUsername'."
   newValue _isOneByteString ifFalse:[ newValue _validateClass: String ].
   hostUsername := newValue
%
category: 'Accessing'
method: GemStoneParameters
password

   "Return the value of the instance variable 'password'."
   ^password
%
category: 'Updating'
method: GemStoneParameters
password: pword

"Set the password for the receiver.  The password is encrypted.
The given password's size is set to zero."

pword _isOneByteString ifFalse:[ pword _validateClass: String ].

pword size == 0
  ifTrue:[ self setLoginPasswordless .
           password := pword copy ]
  ifFalse:[ self setLoginWithPassword .
            password := self _encrypt: pword ].
password immediateInvariant.
self _securePasswords.
pword size: 0.
^ pword
%

category: 'Accessing'
method: GemStoneParameters
username

   "Return the value of the instance variable 'username'."
   ^username
%
category: 'Updating'
method: GemStoneParameters
username: newValue

   "Modify the value of the instance variable 'username'."
   newValue _isOneByteString ifFalse:[ newValue _validateClass: String ].
   username := newValue
%
category: 'Accessing'
method: GemStoneParameters
remoteRepository

"Return nil to indicate no remote repository."

^ nil
%

category: 'Updating'
method: GemStoneParameters
setLoginPasswordless

^ self loginFlags: self passwordlessLoginFlags
%

category: 'Updating'
method: GemStoneParameters
setLoginWithPassword

^  self loginFlags: self defaultLoginFlags
%

category: 'Accessing'
method: GemStoneParameters
defaultLoginFlags
^ 16r11  "GCI_LOGIN_PW_ENCRYPTED | GCI_LOGIN_QUIET"
%

category: 'Accessing'
method: GemStoneParameters
passwordlessLoginFlags
^ 16r90  "GCI_PASSWORDLESS_LOGIN | GCI_LOGIN_QUIET"
%

category: 'Accessing'
method: GemStoneParameters
soloLoginFlag
^ 16r100 "GCI_LOGIN_SOLO"
%

category: 'Accessing'
method: GemStoneParameters
loginFlags

   "Return the value of the instance variable 'loginFlags'."

^ (self dynamicInstVarAt: #loginFlags) ifNil:[ self defaultLoginFlags ] .
%

category: 'Private'
method: GemStoneParameters
loginFlags: anInt
"Do not set loginFlags directly unless you know what you are doing."

self dynamicInstVarAt: #loginFlags put: anInt .
^ self
%

category: 'Accessing'
method: GemStoneParameters
passwordIsEncryptedAsIntegerBoolean

"Answer a C boolean (1 or 0) indicating whether the password is encrypted.
 The password will always be encrypted unless the login is passwordless."
 
^ self loginFlags bitAnd: 1
%

category: 'Formatting'
method: GemStoneParameters
printString
  | res f |
  res := 'stoneNrs:', gemStoneName asString, ' user:', username asString .
  hostUsername ifNotNil:[ res add: ' hostuser:', hostUsername asString ].
  res add: ' gemNrs:', gemService asString .
  (f := self loginFlags) == self defaultLoginFlags ifFalse:[
    res add: ' flags:16r', f asHexString
  ].
  ^ res
%
category: 'Accessing' 
method:
setSoloLogin 
 ^  self loginFlags: (self loginFlags bitOr: self soloLoginFlag)
%
method:
clearQuietLogin 

^ self loginFlags: (self loginFlags bitAnd: (16r10"GCI_LOGIN_QUIET" bitInvert))
%
method:
soloLoginFlag 
 ^ 16r100 "GCI_LOGIN_SOLO"
%

