! BUGFIX 31162
!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   FastIdentityKeyValueDictionary, GsMethodDictionary, 
!     IdentityKeyValueDictionary, KeyValueDictionary, AbstractDictionary
!       Collection, Object
!       
!
!=========================================================================

expectvalue false
run
"temporarily allow subclasses to handle repository upgrade"
| oldFmt |
GsMethodDictionary subclassesDisallowed ifTrue:[
  oldFmt := GsMethodDictionary format .
  GsMethodDictionary _unsafeAt: 2 "offset of format"
     put: (oldFmt bitXor:32"subclasses disallowed bit" ).
  ].
^ GsMethodDictionary subclassesDisallowed 
%

expectvalue %String
run
  GsMethodDictionary _newKernelSubclass: 'FastIdentityKeyValueDictionary'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: { }
    inDictionary: Globals
      options: #()
    reservedOop: 937
%

expectvalue true
run
" restore subclasses disallowed bit to 1 "
| oldFmt |
oldFmt := GsMethodDictionary format .
GsMethodDictionary _unsafeAt: 2 "offset of format"
   put: (oldFmt bitOr:32"subclasses disallowed bit" ) .
^ GsMethodDictionary subclassesDisallowed
%


set class FastIdentityKeyValueDictionary
removeallmethods 
removeallclassmethods 

category: 'For Documentation Installation only'
classmethod: 
installDocumentation

self comment:
'FastIdentityKeyValueDictionary is a subclass of GsMethodDictionary designed
 for customer applications.  FastIdentityKeyValueDictionary employs the same
 internal structure as GsMethodDictionary that is well-suited for efficient 
 execution in smaller dictionaries.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
	valueConstraint: Behavior
	keyConstraint: Behavior' .
%

! Fix 40105 - override this method from GsMethodDictionary for performance
category: 'Private'
method: 
_validatePrivilege
  ^ true
%

! fix 47169
category: 'Enumerating'
method:
associationsDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the argument by
 creating an Association for each key/value pair.  The argument aBlock must
 be a one-argument block.  Returns the receiver."

self keysAndValuesDo: [:aKey :aValue |
  aBlock value: (Association newWithKey: aKey value: aValue)
  ].
%



