!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: canonsymboldict.gs 47587 2020-01-07 18:05:31Z lalmarod $
!
!  New class for AllSymbols in Gemstone64 1.0
!
! Superclass Hierarchy:
!   CanonSymbolDict, CanonStringDict, 
!   AbstractDictionary, Collection, Object.
!
!=========================================================================

expectvalue %String
run
CanonStringDict _newKernelSubclass: #CanonSymbolDict 
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #( disallowGciStore )
  reservedOop: 935 
%

removeallmethods CanonSymbolDict
removeallclassmethods CanonSymbolDict

category: 'For Documentation Installation only'
classmethod: CanonSymbolDict
installDocumentation

self comment: 

'CanonicalSymbolDict is the class of AllSymbols. Instances may
 only be modified by SystemUser, or the SymbolCreation session.

Constraints:
	numElements: SmallInteger
	tableSize: SmallInteger' .
%


! ------------------- Class methods 

! ------------------- Instance methods 
category: 'Private'
method: CanonSymbolDict
validateSystemUser

"validate that the current session is SystemUser."

System myUserProfile userId = 'SystemUser' ifFalse:[
  self error:'instance only modifiable by SystemUser'.
  self _uncontinuableError .
  ^ nil
  ].
^ self  
%

category: 'Private'
method: CanonSymbolDict
_initializeWithoutClear: newSize

"Private. Initializes the instance variables of the receiver to be an empty
 KeyValueDictionary of the specified size. Does not clear the contents
 of the receiver - assumes they are all nil."

self validateSystemUser .
super _initializeWithoutClear: newSize .
^self
%

category: 'Initializing'
method: CanonSymbolDict
initialize: itsSize

"Initializes the instance variables of the receiver to be an empty
 dictionary of the specified size."

self validateSystemUser .
super initialize: itsSize
%


category: 'Adding'
method: CanonSymbolDict
add: aString

"Disallowed, only the Virtual machine's creation of a Symbol
 should add elements to AllSymbols."

^ self shouldNotImplement: #add:

%

category: 'Adding'
method: CanonSymbolDict
addKey: aSymbol

"Only used during repository conversion."

self validateSystemUser .
"We expect that AllSymbols is not yet an instance of this class."
(Globals at:#AllSymbols) class == CanonSymbolDict ifTrue:[
  ^ self error:'Illegal use for other than repository conversion' .
].
aSymbol class == Symbol ifFalse:[
  aSymbol class == DoubleByteSymbol ifFalse:[
    ^ self error:'bad argument class ' , aSymbol class name 
  ].
].
^ super add: aSymbol .
%

category: 'Adding'
method: CanonSymbolDict
addAll: aCollection

"Disallowed, only the Virtual machine's creation of a Symbol
 should add elements to AllSymbols."

^ self shouldNotImplement: #addAll:
%

! associationsDo: not implemented  , CanonSymbolDict's do not hold assocations


category: 'Removing'
method: CanonSymbolDict
remove: aString

^ self shouldNotImplement: #remove:
%

category: 'Removing'
method: CanonSymbolDict
remove: aString ifAbsent: aBlock

^ self shouldNotImplement: #remove:ifAbsent:
%

! edited for 41162, 41110
category: 'Removing'
method: CanonSymbolDict
removeKey: aKey ifAbsent: aBlock

"Removing Symbols from AllSymbols is not supported.  
 If you want to remove Symbols from AllSymbols anyway:
   1. You must logged in as SystemUser, and edit this method to remove 
      the line with    
         shouldNotImplement
      and uncomment the line with
         removeKey: 
      And commit these changes.
   2. Stop the Symbol Creation Session, and all other user sessions
        System stopSymbolCreationSession. 
        System stopUserSessions.
   3. The Symbols to be removed from AllSymbols must be referenced ONLY 
      from AllSymbols, as confirmed by SystemRepository listReferences:.
      OTHERWISE message sends may fail to lookup the proper method
      and you may get other INCORRECT EXECUTION.
   4. execute removals from AllSymbols using this method, and commit.
   5. Start Symbol Creation session using 
        System startSymbolCreationSession.

 Use this process at your own risk.
"

self validateSystemUser .
self shouldNotImplement: #removeKey:ifAbsent: .
"^ super removeKey: aKey ifAbsent: aBlock"
%

! deleted _canonicalizeSymbolAt: offset oldSymbol: oldSym newSymbol: newSym

category: 'Private'
method: CanonSymbolDict
_resetParentRef

"Private. After a become:, the parent refs of the collisionBuckets must
 be reset to point to the correct parent."

self validateSystemUser .
^ super _resetParentRef 
%

category: 'Private'
method: CanonSymbolDict
objectSecurityPolicy: anObjectSecurityPolicy

"Assigns the receiver and all its components to the given security policy.
 Returns the receiver."

self validateSystemUser .
^ super objectSecurityPolicy: anObjectSecurityPolicy
%

! fix 46107
category: 'Updating'
method: CanonSymbolDict
become: aCanonSymbolDict

^ self shouldNotImplement: #become:
%
category: 'Private'
method: CanonSymbolDict
_audit
| cnt |
cnt := 0 .
1 to: tableSize do:[:n |  | bkt |
  bkt := self basicAt: n .
  bkt _audit .
  cnt := cnt + bkt numElements .
].
cnt == numElements ifFalse:[ Error signal: 'bad size']
%
