!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   BtreeQuerySpec,
!   Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods BtreeQuerySpec
removeallclassmethods BtreeQuerySpec

category: 'For Documentation Installation only'
classmethod: BtreeQuerySpec
installDocumentation

self comment:
'BtreeQuerySpec is an abstract class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreeNode that satisfy a particular query.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.'.
%

! ------------------- Class methods for BtreeQuerySpec
! ------------------- Instance methods for BtreeQuerySpec
category: 'Querying'
method: BtreeQuerySpec
addValuesFrom: aLeafNode
start: startIndex
end: endIndex 
into: collection

^ aLeafNode
    _addValues: self
    start: startIndex
    end: endIndex 
    into: collection
%
category: 'Updating'
method: BtreeQuerySpec
rangeIndex: aRangeIndex offset: anOffset pathTerm: aPathTerm

rangeIndex := aRangeIndex.
offset := anOffset.
pathTerm := aPathTerm.
%
category: 'Querying'
method: BtreeQuerySpec
traverseValuesFrom: aLeafNode
start: startIndex
end: endIndex 
previous: previousValue
into: collection

^ aLeafNode
    _traverseValues: self
    start: startIndex
    end: endIndex 
    previous: previousValue
    into: collection
%
category: 'Querying'
method: BtreeQuerySpec
_addValuesFrom: aLeafNode
entrySize: entrySize
start: startIndex
end: endIndex 
into: collection

startIndex to: endIndex by: entrySize do: [ :i |
  collection add: (aLeafNode _basicAt: i).
].
%
category: 'Querying'
method: BtreeQuerySpec
_traverseValuesFrom: aLeafNode
entrySize: entrySize
start: startIndex
end: endIndex 
previous: previousValue
into: collection

  | val prevVal |
prevVal := previousValue.
startIndex to: endIndex by: entrySize do: [ :i |
val := aLeafNode _basicAt: i.
  (val == prevVal)
     ifFalse: [
       rangeIndex _addAllFor: val
         into: collection
         offset: offset
         pathTerm: pathTerm
     ].
  prevVal := val
].
^prevVal
%
category: 'Querying'
method: BtreeQuerySpec
_addRootObjectsFrom: aLeafNode
entrySize: entrySize
start: startIndex
end: endIndex 
into: collection

startIndex to: endIndex by: entrySize do: [ :i |
  collection add: (aLeafNode rootObjectAt: i).
].
%
category: 'Querying'
method: BtreeQuerySpec
addRootObjectsFrom: aLeafNode
start: startIndex
end: endIndex 
into: collection

^ aLeafNode
    _addRootObjects: self
    start: startIndex
    end: endIndex 
    into: collection
%
category: 'Testing'
method: BtreeQuerySpec
canUseOptimizedComparison

  ^ false
%

