!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   BtreeComparisonForSort, BtreeComparisonForCompare, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods BtreeComparisonForSort
removeallclassmethods BtreeComparisonForSort

category: 'For Documentation Installation only'
classmethod: BtreeComparisonForSort
installDocumentation

self comment:
'During btree sort and compare operations (for BtreeNode and subclasses) the exact method
 send for doing comparison operations varies depending upon whether the comparison is for 
 a sort or a query (compare). The class translates the message into a variant for sorting.'.
%

! ------------------- Class methods for BtreeComparisonForSort
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey equalTo: aValue

^ aKey _idxForSortEqualTo: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey greaterThan: aValue

^ aKey _idxForSortGreaterThan: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey greaterThanOrEqualTo: aValue

^ aKey _idxForSortGreaterThanOrEqualTo: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey lessThan: aValue

^ aKey _idxForSortLessThan: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey lessThanOrEqualTo: aValue

^ aKey _idxForSortLessThanOrEqualTo: aValue
%
category: 'Testing'
classmethod: BtreeComparisonForSort
satisfiableQueryGreaterThan: val1 
andEquals: bool1
andLessThan: val2 
andEquals: bool2


  ^( (val1 _idxForCompareGreaterThan: val2) or:
      [ (val1 _idxForSortEqualTo: val2) and: [ (bool1 and:[bool2]) not ] ] ) not
%
! ------------------- Instance methods for BtreeComparisonForSort
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForSort
compareKey: aKey equalTo: aValue

^ aKey _idxForSortEqualTo: aValue
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForSort
compareKey: aKey greaterThan: aValue

^ aKey _idxForSortGreaterThan: aValue
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForSort
compareKey: aKey greaterThanOrEqualTo: aValue

^ aKey _idxForSortGreaterThanOrEqualTo: aValue
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForSort
compareKey: aKey lessThan: aValue

^ aKey _idxForSortLessThan: aValue
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForSort
compareKey: aKey lessThanOrEqualTo: aValue

^ aKey _idxForSortLessThanOrEqualTo: aValue
%
category: 'Testing'
set compile_env: 0
method: BtreeComparisonForSort
satisfiableQueryGreaterThan: val1 
andEquals: bool1
andLessThan: val2 
andEquals: bool2


  ^( (val1 _idxForCompareGreaterThan: val2) or:
      [ (val1 _idxForSortEqualTo: val2) and: [ (bool1 and:[bool2]) not ] ] ) not
%
