expectvalue %String
run
^ GsTlsCredential _newKernelSubclass: #GsX509Certificate
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #()
  reservedOop: nil
%


doit
GsX509Certificate category: 'X509'.
true
%


! Remove existing behavior from GsX509Certificate
removeallmethods GsX509Certificate
removeallclassmethods GsX509Certificate

! ------------------- Class methods for GsX509Certificate
classmethod:
comment
^'GsX509Certificate encapsulates a TLS/SSL CA certificate per X.509.'
%

category: 'Instance Creation'
classmethod:
newFromPemFile: fileNameString
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple certificates, only
 the first is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver."
 
^ self tls3ArgPrim: 0 with: fileNameString with: nil with: 3
%


category: 'Instance Creation'
classmethod:
newFromPemString: aPemString
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple certificates, only the first is read.

 Raises an exception if the string is not in PEM format or if the type of object in 
 the PEM string does not match the receiver."
 
^ self tls3ArgPrim: 1 with: aPemString with: nil with: 3
%

category: 'Testing'
method:
isPrivateKey
 ^ false
%
category: 'Testing'
method:
isPublicKey
 ^ false
%
category: 'Testing'
method:
isX509Certificate
 ^ true
%

category: 'Converting'
method:
publicKeySpecies
 ^ GsTlsPublicKey
%
 
category: 'Converting'
method:
asPublicKey
"Extract the public key from the receiver and return a new instance
 of the public key class for the receiver (default: GsTlsPublicKey)."
 
 ^ self publicKeySpecies fromCertificate: self
%

category: 'Testing'
method:
canVerifyDigitalSignatures
^ self supportsDigitalSignatures
%

category: 'Testing'
method:
canCreateDigitalSignatures

^ false
%
