expectvalue /String
run
(Object subclass: 'GsTsExternalSession'
  instVarNames:#( tsSession socket gciErr callouts lib objInfoBuffers
                  stoneSessionId gemProcessId parameters performArgs 
                  lastResult nbCallInProgress )
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #( instancesNonPersistent)) definition
%
set class GsTsExternalSession
removeallmethods
removeallclassmethods

classmethod
comment
^ 'A GsTsExternalSession represents a connection to a another session
   using the threads-safe GCI library , GciTs , to access that session via FFI.
'
%

category: 'Instance creation'
classmethod:
parameters: aGemStoneParameters library: aGciTsLibrary
 ^ self new 
    _parameters: aGemStoneParameters library: aGciTsLibrary
%
category: 'Private'
method:
_parameters: aGemStoneParameters library: aGciTsLibrary
  parameters := aGemStoneParameters .
  parameters ifNil:[
    (parameters := GemStoneParameters new)
      gemService: GsNetworkResourceString defaultGemNRSFromCurrent asString ;
      gemStoneName: GsNetworkResourceString defaultStoneNRSFromCurrent asString ;
      username: System myUserProfile userId ;
      password: 'swordfish' copy  .
  ].
  callouts := aGciTsLibrary callouts .
  lib := aGciTsLibrary .  "save for debugging"
%
classmethod:
newDefault: aGciTsLibrary
  ^ self parameters: nil library: aGciTsLibrary
%
method:
_calloutAt: ofs name: aSymbol
 | c n |
 c := callouts at: ofs .
 (n := c name) == aSymbol ifFalse:[ Error signal:'callout mismatch'].
 ^ c
%

method
_stringArg: aString
 ^ aString ifNil:[ '' ] ifNotNil:[:s | s ].
%

category: 'Accessing'
method:
errorString
  gciErr ifNotNil:[
    gciErr number ~~ 0 ifTrue:[
      ^ 'ERROR ', gciErr number asString, ' ', gciErr message asString
    ].
  ].
  ^ 'no error'.
%
method:
lastResult
  ^ lastResult
%

method
clearError
  gciErr ifNotNil:[
    gciErr memset: 0 from: 0 to: gciErr size - 1
  ].
%

method:
stoneSessionId
  ^ stoneSessionId ifNil:[ 
    stoneSessionId := self send: #session to: System withArguments: nil
  ].
%
method
gemProcessId
  ^ gemProcessId ifNil:[ 
    gemProcessId := self send: #gemProcessId to: System withArguments: nil
  ].
%

category: 'Login'.
method:
login
 | c ptr args |
 self isLoggedIn ifTrue:[ ^ ImproperOperation signal:'already logged in'].
 c := self _calloutAt: 1 name: #'GciTsLogin' .
 gciErr := GciErrSType new .
 args := {    
   self _stringArg: parameters gemStoneName .
   self _stringArg: parameters hostUsername .
   self _stringArg: parameters hostPassword .
   parameters passwordIsEncryptedAsIntegerBoolean.  "BoolType  hostPwIsEncrypted" 
   self _stringArg: parameters gemService .
   self _stringArg: parameters username .
   self _stringArg: parameters password .
   parameters loginFlags .  "unsigned int loginFlags per GCI_LOGIN* "
   0 . "int haltOnErrNum"
 }.
 c numFixedArgs == 11 ifTrue:[  "GciTs v3.5.x + "
   args add:( CByteArray gcMalloc: 4 "BoolType *executedSessionInit").
 ].
 args add: gciErr .
 ptr := c callWith: args .
 ptr memoryAddress == 0 ifTrue:[
   self _signalError:'GciTsLogin failed'.
 ].
 tsSession := ptr .
 socket := GsSocket fromFileHandle: self _getSocketFd .
%    
category: 'Login'.
method:
loginSolo
   parameters setSoloLogin .
   ^ self login
%
 
category: 'Accessing'
method:
parameters
  ^ parameters
%
category: 'Private'
method:
_signalError: aString
  | err |
  (err := GciError new) error: gciErr in: self details: nil .
  err originalNumber >= 4000 ifTrue:[
    self _closeConnection . "ensure connection is closed after fatal error"
  ].
  err signal .
%
! fix 49075
method:
_closeConnection
  "do not close socket, let C code do that"
  self nbLogout
%

method: 
_getSocketFd
  | c res |
  c := self _calloutAt: 13 name: #'GciTsSocket' . 
  res := c callWith: { tsSession . gciErr }.
  res > 0 ifFalse:[ 
    self _signalError:'GciTsSocket failed'.
  ].
  ^ res
%
category: 'Accessing'
method:
isLoggedIn
  | c res |
  tsSession ifNil:[ ^ false ].
  c := self _calloutAt: 13 name: #'GciTsSocket' . 
  res := c callWith: { tsSession . gciErr }.
  ^ res > 0
%
method:
isCallInProgress
  ^ tsSession ~~ nil and:[ nbCallInProgress ~~ nil ]
%
category: 'Non Blocking Calls'
method:
waitForReadReady
  "Use the ProcessorScheduler to wait for this session's socket to 
   be ready to read, allowing other GsProcess to run while we are waiting."
  ^ socket _waitForReadReady
% 
method
waitForResult
  socket _waitForReadReady .
  ^ self nbResult. 
%
method:
isResultAvailable
  "Return true if result ready or if the socket shows an error"
  | status |
  self isCallInProgress ifFalse:[ Error signal:'call not in progress']. 
  status := socket readWillNotBlockWithin: 0 .
  status == true ifTrue:[ self nbResult .  ^ true ].
  status ifNil:[ ^ self _signalError:'socket error' ].
  ^ false 
%
method:
waitForReadReadyTimeOut: msToWait
  "Use the ProcessorScheduler to wait for this session's socket to 
   be ready to read, allowing other GsProcess to run while we are waiting.
 
   The argument msToWait is a SmallInteger  >= 0 , units of milliseconds.
   Signal an error if the socket is not read to read within the specified time.
  "
  | status |
  status := socket readWillNotBlockWithin: msToWait .
  status == true ifTrue:[ ^ self "success"].
  status ifNil:[
    self _signalError:'socket error'.
  ].
  Error signal:'wait for result timed out'.
% 
category: 'Private'
method:
_clearConnection
  tsSession := nil .
  nbCallInProgress := nil .
  gciErr := nil .
  socket := nil 
%

category: 'Calls'.
method:
logout
  | c res |
  c := self _calloutAt: 2 name: #'GciTsLogout' .
  res := c callWith: { tsSession . gciErr } .
  self _clearConnection .
%
method:
forceLogout
 ^ self nbLogout
%
method:
nbLogout
  "Does not wait for a result from the gem."
  | c res |
  c := self _calloutAt: 10 name: #'GciTsNbLogout' .
  res := c callWith: { tsSession . gciErr } .
  self _clearConnection .
%
method:
_waitForLogout
  "not implemented"
  ^ self
%

method: 
abort 
  | c res |
  c := self _calloutAt: 3 name: #'GciTsAbort' .
  res := c callWith: { tsSession . gciErr }.
  res == 1 ifFalse:[
    self _signalError:'GciTsAbort failed'.
  ].
%
method: 
commit 
  | c res |
  c := self _calloutAt: 4 name: #'GciTsCommit' .
  res := c callWith: { tsSession . gciErr }.
  res == 1 ifFalse:[
    self _signalError:'GciTsCommit failed'.
  ].
%
method:
executeString: aString
  | c res |
  c := self _calloutAt: 5 name: #'GciTsExecute' .
  aString _isOneByteString ifFalse:[
    ArgumentError signal:'argument to executeString is not a String'.
  ].
  res := c callWith: { tsSession . 
                       aString . 74753"String asOop" .  "sourcStr, sourceOop"
                       1"oopIllegal,  context" .
                       20"nil asOop , symbolList" .  
                       1"GCI_PERFORM_FLAG_ENABLE_DEBUG, flags" .
                        0"envId" . 
                       gciErr }.
  res == 1"oopIllegal" ifTrue:[
    self _signalError:'GciTsExecute failed'.
  ] .
  ^ ( lastResult := self resolveResult: res ).
%
method:
executeBlock: aBlock
  "Execute the code in the Block argument in the external Gem
   and answer the result. The best values to return are specials.
   Strings and other byte objects are copied to the local Gem.
   All other responses are returned as a Array containing a single OOP."

   ^self executeString: (self _stringForBlock: aBlock)
%
method:
executeBlock: aBlock with: aValue

^ self executeBlock: aBlock withArguments: {aValue}.
%
method:
executeBlock: aBlock with: vOne with: vTwo

^ self executeBlock: aBlock withArguments:{ vOne . vTwo }
%
method:
executeBlock: aBlock withArguments: someValues
  "Execute the code in the Block argument in the external Gem, passing
   in the specified values, and answer the result. The values passed to the
   Block must be ones whose printString allows the correct object state to
   be recreated (such as numbers and strings, for example).
   The best values to return are specials.
   Strings and other byte objects are copied to the local Gem.
   All other responses are returned as a Array containing a single OOP."

  ^self executeString: (self _stringForBlock: aBlock withArguments: someValues)
%

method:
forkBlock: aBlock 

^ self forkString:(self _stringForBlock: aBlock )
%
method:
forkBlock: aBlock with: aValue 

^   self forkBlock: aBlock withArguments: {aValue }
%

method:
forkBlock: aBlock with: aValue with: anotherValue

^   self forkBlock: aBlock withArguments: {aValue. anotherValue}.
%
method:
forkBlock: aBlock withArguments: someValues
  "Execute the code in the Block argument in the external Gem, passing
   in the specified values, and do not wait for a result. The values passed 
   to the Block must be ones whose printString allows the correct object 
   state to be recreated (such as numbers and strings, for example).
   At some later point, you would check for a result. Otherwise you cannot
   issue another call, as the current call would remain in progress.  
   Refer to #executeString: for an example of the complete send, wait, response sequence."

  self forkString: (self _stringForBlock: aBlock withArguments: someValues)
%

method:
forkString: aString

 "Must be followed by GsTsExternalSession >> nbResult ."

^ self nbExecute: aString
%

method: 
send: aSelector to: anObject 
 ^ self send: aSelector to: anObject withArguments: nil
%

method: 
send: aSelector to: anObject withArguments: anArray
 | c res args nArgs ofs |
 c := self _calloutAt: 6 name: #'GciTsPerform' .
 nArgs := anArray size .
 (args := performArgs) size < (8 * nArgs) ifTrue:[
   args := performArgs := CByteArray gcMalloc: 8 * nArgs .
 ].
 ofs := 0 .
 1 to: nArgs do:[:n |
   args uint64At: ofs put: (anArray at: n) asOop . 
   ofs := ofs + 8 .
 ].
 aSelector _isSymbol ifTrue:[
   res := c callWith: { tsSession . anObject asOop .
                        aSelector asOop .  nil . args . nArgs . 
                        1"GCI_PERFORM_FLAG_ENABLE_DEBUG, flags" .
                        0 "envId" . gciErr }
 ] ifFalse:[
   aSelector _isOneByteString ifFalse:[ Error signal:'aSelector neither a Symbol nor String'].
   res := c callWith: { tsSession .  anObject asOop .
                        20"nil asOop".  aSelector . args . nArgs  .
                        1"GCI_PERFORM_FLAG_ENABLE_DEBUG, flags" .
                        0 "envId" . gciErr }
 ].
 res == 1"oopIllegal" ifTrue:[
   self _signalError:'GciTsNbPerform failed'.
 ] .
 ^ ( lastResult := self resolveResult: res ).
%
category: 'Non Blocking Calls'
method:
nbExecute: aString
 "Must be followed by GsTsExternalSession >> nbResult ."
  | c res |
  c := self _calloutAt: 14 name: #'GciTsNbExecute' . 
  aString _isOneByteString ifFalse:[
    ArgumentError signal:'argument to nbExecute: is not a String'.
  ].
  res := c callWith: { tsSession .
                       aString . 74753"String asOop" .  "sourcStr, sourceOop"
                       1"oopIllegal,  context" .
                       20"nil asOop , symbolList" .
                       1"GCI_PERFORM_FLAG_ENABLE_DEBUG, flags" .
                        0"envId" .
                       gciErr }.
  res == 1 ifFalse:[
    self _signalError:'GciTsNbExecute failed'.
  ].
  nbCallInProgress := true .
%

method:
nbSend: aSelector to: anObject withArguments: anArray 
 "Must be followed by GsTsExternalSession >> nbResult ."
 | c res args nArgs ofs |
 c := self _calloutAt: 11 name: #'GciTsNbPerform' .  
 (args := performArgs) size < (nArgs := anArray size) ifTrue:[
   args := performArgs := CByteArray gcMalloc: 8 * nArgs .
 ].
 ofs := 0 .
 1 to: nArgs do:[:n |
   args uint64At: ofs put: (anArray at: n) asOop . 
   ofs := ofs + 8 .
 ].
 aSelector _isSymbol ifTrue:[
   res := c callWith: { tsSession . anObject asOop .
                        aSelector asOop .  nil . args . nArgs . 
                        1"GCI_PERFORM_FLAG_ENABLE_DEBUG, flags" .
                        0 "envId" . gciErr }
 ] ifFalse:[
   aSelector _isOneByteString ifFalse:[ Error signal:'aSelector neither a Symbol nor String'].
   res := c callWith: { tsSession .  anObject asOop .
                        20"nil asOop".  aSelector . args . nArgs  .
                        1"GCI_PERFORM_FLAG_ENABLE_DEBUG, flags" .
                        0 "envId" . gciErr }
 ].
 res == 1 ifFalse:[
   self _signalError:'GciTsNbPerform failed'.
 ].
 nbCallInProgress := true .
%

category: 'Private'
method: 
_stringForBlock: aBlock
        | string |
        string := aBlock method _sourceStringForBlock .
  (string at: 1) == $[  ifFalse:[ Error signal:'malformed source'].
  "replace [ ]  with spaces"
  string at: 1 put: $  ; at: string size put: $  .
  ^ string
%
method:
_stringForBlock: aBlock withArguments: someValues
  | stream string |
  aBlock numArgs == someValues size ifFalse: [self error: 'Wrong number of arguments'].
  stream := AppendStream on: String new .
  stream nextPutAll: aBlock method _sourceStringForBlock .
  stream nextPutAll: ' valueWithArguments: {'.
  1 to: someValues size do: [:index | | each |
    each := someValues at: index .
    index > 1 ifTrue: [stream nextPutAll: '. '].
    each printOn: stream.
  ].
  stream nextPut: $}  .
  string := stream contents.
  (string at: 1) == $[  ifFalse:[ Error signal:'malformed source'].
  ^ string
%


method:
_nbResult
 | c res |
 c := self _calloutAt: 12 name: #'GciTsNbResult' .  
 res := c callWith: { tsSession . gciErr }.
 nbCallInProgress := nil .
 res == 1"oopIllegal" ifTrue:[
   self _signalError:'GciTsNbResult failed'.
 ] .
 ^ res .
%
category: 'Non Blocking Calls'
method:
nbResult
 ^ (lastResult := self resolveResult: self _nbResult)
%

method:
nbCommittedResult
 ^ Object objectForOop: self _nbResult  "assumes result is committed in this stone"
%

category: 'Error handling'
method:
clearStackFor: aGciError
 | contextOop c res |
 (contextOop := aGciError context) == 20"nil asOop" ifTrue: [^self].
 c := self _calloutAt: 8 name: #'GciTsClearStack' .
 res := c callWith: { tsSession . contextOop . gciErr }.
 res == 1 ifFalse:[
   self _signalError:'GciTsClearStack failed'. 
 ]
% 

method:
continue: contextOop
  "used by GciError >> continue"
  ^ self continue: contextOop replacingTopOfStackWithOop: 1"OOP_ILLEGAL"
%
method:
continue: contextOop with: anObject
  ^ self continue: contextOop replacingTopOfStackWithOop: anObject asOop
%
method:
continue: contextOop replacingTopOfStackWithOop: tosOop
  | c res flags |
  contextOop == 20"nil asOop" ifTrue: [^self].
  c := self _calloutAt: 7 name: #'GciTsContinueWith' .
  flags := 1 "GCI_PERFORM_FLAG_ENABLE_DEBUG" .
  res := c callWith: { tsSession . contextOop . tosOop . 
                       nil "GciErrSType *continueWithError = NULL" .
                       flags . gciErr }.
  res == 1"oopIllegal" ifTrue:[
    self _signalError:'GciTsContinueWith failed'.
  ].
  ^ ( lastResult := self resolveResult: res ).
%
category: 'Private'
method:
_getObjInfo: anOop buffer: aCByteArray 
 | c res info oId |
 c := self _calloutAt: 9 name: #'GciTsFetchObjInfo'.
 info := objInfoBuffers at: 1 .
 res := c callWith: { tsSession . anOop . 0"BoolType addToExportSet".
                       info .
                       aCByteArray . aCByteArray size .
                       gciErr }.
 res == -1 ifTrue:[
    self _signalError:'GciTsFetchObjInfo failed'.
 ].
 (oId := info uint64At: 0 ) == anOop ifFalse:[
   Error signal:'Inconsistent objId'.
 ].
 ^ info
%

method:
resolveResult: anOop 
  | implem info bufSize buf classOop objSize |
  (anOop bitAnd: 6) ~~ 0 ifTrue:[ 
    ^ Object _objectForOop: anOop   "a special"
  ]. 
  bufSize := 1024 .
  objInfoBuffers ifNil:[ 
    info := CByteArray gcMalloc: 40 "sizeof(GciTsObjInfo)" .
    buf :=  CByteArray gcMalloc: bufSize .
    objInfoBuffers := { info . buf }.
  ]. 
  buf := objInfoBuffers at: 2 .
  info := self _getObjInfo: anOop buffer: buf .
  implem := info  uint16At: 34 ."_bits"
  implem := implem bitAnd: 3 .
  implem == 3 ifTrue:[ 
    ^ Object _objectForOop: anOop "a special" 
  ].
  classOop := info uint64At: 8 .
  classOop == 0 ifTrue:[
    Error signal:'Read access denied for object ', anOop asString.
  ].
  objSize := info uint64At: 16 .
  implem == 1 ifTrue:[  "byte format" 
    objSize > bufSize ifTrue:[
      buf := CByteArray gcMalloc: objSize .
      self _getObjInfo: anOop buffer: buf . 
    ]. 
    classOop == 74753"String asOop" ifTrue: [
      ^ buf stringFrom: 0 to: objSize - 1.
    ].
    classOop == 110849"Symbol asOop" ifTrue: [
     ^ Symbol withAll: (buf stringFrom: 0 to: objSize - 1).
    ].
    ^ buf byteArrayFrom: 0 to: objSize - 1.
  ].
  ^ { anOop . classOop . objSize }.
%

method:
resolveResult: anOop toLevel: anInteger
  "Used by GciError >> signalCompileError .
   Not fully generalized. 
   Returns a special or byte object, or an Array of resolved objects,
   or a CByteArray containing oop of some other object. "
  | arr classOop buf res |
  arr := self resolveResult: anOop .
  (arr _isArray) ifFalse:[ ^ arr  ].  "a special or a byte object"
  classOop := arr at: 2 .
  (classOop == 66817"Array asOop" and: [0 < anInteger]) ifTrue: [
    | size array |
    buf := objInfoBuffers at: 2 . "already fetched first 1024 bytes"
    size := (arr at: 3) min:( buf size // 8 ) .
    array := Array new: size .
    1 to: size do:[:n | | oop |
      oop := buf uint64At: (n - 1) * 8 .
      array at: n put: (self resolveResult: oop toLevel: anInteger - 1).
    ].
    ^ array.
  ].
  "Not a recognized object"
  res := CByteArray gcMalloc: 8.
  res uint64At: 0 put: anOop.
  ^ res .
%
method:
_getStackForOop: gcierrContextOop
  | str |
  str := 'GsExternalSession _stackReport: ' , gcierrContextOop asString .
  self nbExecute: str .
  self waitForReadReadyTimeOut: 20000 .
  ^ self nbResult .
%


