!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   SelectBlock, BlockClosure, Object.
!
!=========================================================================

removeallmethods SelectBlock
removeallclassmethods SelectBlock

category: 'For Documentation Installation only'
classmethod: SelectBlock
installDocumentation

self comment:

'SelectBlock is a concrete subclass of BlockClosure that supports selection
 blocks for associative access.

Constraints:
	queryBlock: ExecBlock
	iterationBlock: ExecBlock

--- instVar iterationBlock
An ExecBlock.  The firstPC instance variable of this block refers to the
 first bytecode to execute to begin execution of this block in GemStone 
 Smalltalk (no associative access), and the lastPC instance variable refers 
 to the last bytecode of the block''s GemStone Smalltalk execution.

--- instVar queryBlock
An ExecBlock.  The firstPC instance variable of this block refers to the
 first bytecode to execute to begin an associative access query, and the lastPC
 instance variable refers to the last bytecode of the associative access
 query.
' .
%

set compile_env: 0
category: 'Accessing'
method: SelectBlock
argumentCount
	"A SelectBlock can only take one argument."

	^self queryBlock argumentCount.
%

category: 'Accessing'
method: SelectBlock
queryBlock

"Returns the value of the queryBlock instance variable."

^queryBlock
%

category: 'Accessing'
method: SelectBlock
iterationBlock

"Returns the value of the iterationBlock instance variable."

^iterationBlock
%

set compile_env: 0
category: 'Block Evaluation'
method: SelectBlock
ensure: aBlock
	"Evaluate the receiver.  
	 Evaluate aBlock after evaluating the receiver,
	 or before any return from a block that would return to the sender.
	 Returns result of evaluating the receiver.

	 aBlock must be a zero-arg instance of ExecBlock, otherwise an error is generated. "

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #ensure:.
%

set compile_env: 0
category: 'Block Evaluation'
method: SelectBlock
ifCurtailed: terminationBlock
	"Evaluate the receiver and return its result. If abnormal termination of the receiver occurs,
	 terminationBlock is evaluated. The value returned from the evaluation of
	 terminationBlock is discarded."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #ifCurtailed:.
%

set compile_env: 0
category: 'Block Evaluation'
method: SelectBlock
on: exceptionSelector do: handlerBlock
	"Try to evaluate the receiver, which should be a zero-argument block.
	 If an exception occurs and the expression exceptionSelector handles: theExceptionInstance
	 returns true, then evaluate the one argument block handlerBlock, passing it the exception
	 instance as its argument.

	 These forms are supported directly by the VM 
		(1) on: anException do: handlerBlock
		(2) on: anExceptionSet do: handlerBlock
	 This form is handled by Smalltalk code in the body of this method.
		(3) on: anObject do: handlerBlock

	 anException must be the class Exception  or a subclass thereof;
	 anExceptionSet must be a kind of ExceptionSet;
	 handlerBlock must be an instance of ExecBloc otherwise an error is generated.

	 For forms 1, 2, and 3 if handlerBlock is not a one argument block,
	 an error is generated if exception handling attempts to invoke that handlerBlock.  

	 If handlerBlock is invoked to handle an Exception which occurs during execution of the
	 receiver and handlerBlock completes normally , then the result of handlerBlock (the value
	 of the last expression in handlerBlock) will be the result of the on:do: send .  Other-than-normal
	 completion of handlerBlock is available by use of Exception's instance methods such as
	 #return, #return:, #retry, #retryUsing:, #resume, #resume:, #pass, and #outer within handlerBlock.

	 For forms 1 and 2, when searching for a handlerBlock to handle a signaled Exception, the VM
	 uses Behavior>>_subclassOf: semantics . classHistories of the class of the signaled Exception
	 and of anException or elements of anExceptionSet are ignored."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #on:do:.
%

set compile_env: 0
category: 'Block Evaluation'
method: SelectBlock
value
	"Return the value of the receiver evaluated with no arguments.
	 If the receiver expects any arguments, signal an error."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #value.
%

category: 'Block Evaluation'
method: SelectBlock
value: anObject

"Returns the value of the receiver evaluated with anObject as its
 argument.  A SelectBlock can only take one argument."

^iterationBlock value: anObject
%

set compile_env: 0
category: 'Block Evaluation'
method: SelectBlock
value: firstObject value: secondObject
	"Return the value of the receiver evaluated with the specified arguments.  If
	 the receiver expects a different number of arguments, signal an error."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #value:value:.
%

set compile_env: 0
category: 'Block Evaluation'
method: SelectBlock
valueWithArguments: argList
	"Return the value of the receiver evaluated with the specified arguments.  If
	 the receiver expects a different number of arguments, signal an error."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #valueWithArguments:.
%

set compile_env: 0
category: 'Flow of Control'
method: SelectBlock
whileFalse
	"Evaluate the receiver once and then repeatedly as long as the value
	 returned by the evaluation is false."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #whileFalse.
%

set compile_env: 0
category: 'Flow of Control'
method: SelectBlock
whileFalse: aBlock
	"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
	 while the receiver evaluates to false.  Return nil.  Generates an error if the
	 receiver is not a zero-argument block."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #whileFalse:.
%

set compile_env: 0
category: 'Flow of Control'
method: SelectBlock
whileTrue
	"Evaluate the receiver once and then repeatedly as long as the value
	 returned by the evaluation is true."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #whileTrue.
%

set compile_env: 0
category: 'Flow of Control'
method: SelectBlock
whileTrue: aBlock
	"(Reserved selector.)  Evaluates the zero-argument block aBlock repeatedly
	 while the receiver evaluates to true.  Return nil.  Generates an error if the
	 receiver is not a zero-argument block."

	"SelectBlocks require a single argument, so this selector does not apply."
	^self shouldNotImplement: #whileTrue:.
%
