!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: rcequalityindexspec.gs 19139 2008-05-30 23:48:14Z stever $
!
! Superclass Hierarchy:
!   RcEqualityIndexSpecification,
!   EqualityIndexSpecification,
!   AbstractIndexSpecification,
!   Object.
!
!=========================================================================

! class created in idxclasses.topaz

! Remove existing behavior from RcEqualityIndexSpecification
doit
RcEqualityIndexSpecification removeAllMethods.
RcEqualityIndexSpecification class removeAllMethods.
true
%

! ------------------- Class methods for RcEqualityIndexSpecification
category: 'For Documentation Installation only'
classmethod: RcEqualityIndexSpecification
installDocumentation

self comment:
'The class RcEqualityIndexSpecification provides details for specifying an equality index that is 
reduced conflict.'.
%

! ------------------- Instance methods for RcEqualityIndexSpecification
category: 'accessing'
method: RcEqualityIndexSpecification
equalityIndexClass
  ^ self legacyIndex
    ifTrue: [ RcRangeEqualityIndex ]
    ifFalse: [ GsRangeEqualityIndex ]
%

! delete createIndexOn:

! delete indexTypePrintString

category: 'accessing'
set compile_env: 0
method: RcEqualityIndexSpecification
_createIndex
  ^ super _createIndex
%
category: 'accessing'
set compile_env: 0
method: RcEqualityIndexSpecification
options
  ^ super options setReducedConflict
%
