!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcCounterElement, Object.
!
!=========================================================================

expectvalue %String
run
^ Object _newKernelSubclass: 'RcCounterElement'
  instVarNames: #(#value)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
      options: #()
  reservedOop: 847
%

removeallmethods RcCounterElement
removeallclassmethods RcCounterElement

category: 'For Documentation Installation only'
classmethod: RcCounterElement
installDocumentation

self comment:
'RcCounterElement implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.
'
%

! ------------------- Class methods for RcCounterElement
category: 'Instance Creation'
classmethod: RcCounterElement
new

"Creates and returns a new instance of the receiver."

^ self basicNew initialize
%

! ------------------- Instance methods for RcCounterElement
category: 'Updating'
method: RcCounterElement
decrementValueBy: aNumber

"Decrement the current value by the given amount."

value := value - aNumber
%

category: 'Updating'
method: RcCounterElement
incrementValueBy: aNumber

"Increments the current value by the given amount."

value := value + aNumber
%

category: 'Initialization'
method: RcCounterElement
initialize

"Initializes the value to be zero."

self value: 0
%

category: 'Accessing'
method: RcCounterElement
value

"Returns the value of the instance variable 'value'."

^ value
%

category: 'Updating'
method: RcCounterElement
value: newValue

"Modifies the value of the instance variable 'value'."

value := newValue
%

