!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcBtreeInteriorNode, BtreeInteriorNode, BtreeNode, Array, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods RcBtreeInteriorNode
removeallclassmethods RcBtreeInteriorNode

category: 'For Documentation Installation only'
classmethod: RcBtreeInteriorNode
installDocumentation

self comment:
'A RcBtreeInteriorNode represents an interior node of a B-tree for which a
binary search can be done for a key. Updates to instances of this class are 
logged and can  be replayed in the case of commit conflicts.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger
	lastValue: Object' .
%

! ------------------- Class methods for RcBtreeInteriorNode
! ------------------- Instance methods for RcBtreeInteriorNode
category: 'Updating'
method: RcBtreeInteriorNode
at: aKey put: aValue

self shouldNotImplement: #at:put:
%
category: 'Updating'
method: RcBtreeInteriorNode
btreeAt: aKey put: aValue

""

self shouldNotImplement: #btreeAt:put:
%
category: 'Updating'
method: RcBtreeInteriorNode
btreeAt: aKey put: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil

| res |
(selectiveAbortSetOrNil ~~ nil and: [ (selectiveAbortSetOrNil includes: self) not ])
        ifTrue: [ 
                selectiveAbortSetOrNil add: self.
                self _selectiveAbort ].
res := self _at: aKey put: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
category: 'Constants'
method: RcBtreeInteriorNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ RcBtreeInteriorNode
%
category: 'Removing'
method: RcBtreeInteriorNode
removeKey: aKey value: aValue

self shouldNotImplement: #removeKey:value:
%
category: 'Removing'
method: RcBtreeInteriorNode
removeKey: aKey value: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil

| res |
(selectiveAbortSetOrNil ~~ nil and: [ (selectiveAbortSetOrNil includes: self) not ])
        ifTrue: [ 
                selectiveAbortSetOrNil add: self.
                self _selectiveAbort ].
res := self _removeKey: aKey value: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
