"
No class-specific documentation for PortRange, hierarchy is: 
Object
  PortRange( ports numPorts )

"
Class {
	#name : 'PortRange',
	#superclass : 'Object',
	#instVars : Array [
		'ports',
		'numPorts'
	],
	#category : 'X509-HostAgent'
}

{ #category : 'instance creation' }
PortRange class >> lowPort: lowPort highPort: highPort avoidPort: avoidPort [

	highPort < lowPort
		ifTrue: [ArgumentError signal: 'highPort must be >= lowPort'].
	^self new
		initializeForLowPort: lowPort
		highPort: highPort
		avoidPort: avoidPort
]

{ #category : 'printing' }
PortRange >> asString [
  | str |
  str := String new .
  ports do:[:x | str addAll: x printString ; addAll:' . ' ].  
  ^ str
]

{ #category : 'enumeration' }
PortRange >> detect: aBlock ifNone: noneBlock [
	"Equivalent to OrderedCollection detect:ifNone: but starting at a 
   random point in the port numbers."

	| startOfs |
	startOfs := HostRandom new integerBetween: 1 and: numPorts - 1 .
  ports do:[ :aRange |
    startOfs to: aRange size do:[:ofs | | portNum |
      (aBlock value: (portNum := aRange at: ofs)) ifTrue:[ ^ portNum]
    ].
    startOfs := (startOfs - aRange size) min: 1 .
  ].
	"Tried them all, none worked."
	^noneBlock value
]

{ #category : 'initialization' }
PortRange >> initializeForLowPort: lowPort highPort: highPort avoidPort: avoidPort [
	| count |
  "initialize ports to an Array of 1 or 2 Intervals"
  GsFile gciLogServer: 'PortRange  low ', lowPort asString, ' high ', 
									highPort asString, ' avoid ' , avoidPort asString .
  numPorts := highPort - lowPort  .
  avoidPort == lowPort 
    ifTrue:[ ports := { lowPort + 1 to: highPort }. ] ifFalse:[
  avoidPort == highPort 
    ifTrue:[ ports := lowPort to: highPort - 1] ifFalse:[
  (avoidPort > lowPort and:[ avoidPort < highPort]) 
    ifTrue:[ ports := { lowPort to: avoidPort - 1 . avoidPort + 1 to: highPort }. 
  ] ifFalse:[
    ports := { lowPort to: highPort } .
    numPorts := highPort - lowPort + 1. "no port to avoid"
  ]]].
  count := 0 .
  ports do:[:aRange | count := count + aRange size ].
	^self
]
