!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ObsoleteSymbolKeyValueDictionary, StringKeyValueDictionary, 
!   KeyValueDictionary, AbstractDictionary, Collection, Object.
!
!=========================================================================

removeallmethods ObsoleteSymbolKeyValueDictionary
removeallclassmethods ObsoleteSymbolKeyValueDictionary

category: 'For Documentation Installation only'
classmethod: ObsoleteSymbolKeyValueDictionary
installDocumentation

self comment:
'The class ObsoleteSymbolKeyValueDictionary is obsolete as of GemStone version 5.0 
and will be removed in a future release.  

Existing instances should be migrated to SymbolKeyValueDictionary or otherwise
processed as required, and then should be removed.' .
%

category: 'Updating'
method: ObsoleteSymbolKeyValueDictionary
at: aKey put: aValue

"Stores the aKey/aValue pair in the receiver.  If aKey is a CharacterCollection
 but not an obsolete symbol, an obsolete symbol of equal value is created for 
 the key.  Rebuilds
 the hash table if the addition causes the number of collisions to exceed the
 limit allowed.  Returns aValue.

 If aKey is being added for the first time, an invariant copy of it is stored
 as the key."

"_stringAt:put: primitive has been removed from the VM."
Error signal:'ObsoleteSymbolKeyValueDictionary>>at:put: no longer implemented'.
%

category: 'Storing and Loading'
classmethod: ObsoleteSymbolKeyValueDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: SymbolKeyValueDictionary
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
convertToSymbolKeyValDict

"Private. Converts the receiver to be an instance of SymbolKeyValueDictionary."

<primitive: 484>
self _primitiveFailed: #convertToSymbolKeyValDict
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
convertToStringKeyValDict

"Private. Converts the receiver to be an instance of StringKeyValueDictionary."

<primitive: 484>
self _primitiveFailed: #convertToStringKeyValDict
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
containsOnlySymbols

"Private. Checks to see if all its keys are Symbols (and not ObsoleteSymbols)"

self keysDo: [ :aKey |
  (aKey _isSymbol) ifFalse: [ ^ false ]
  ].

^ true.
%

category: 'Repository Conversion'
method: ObsoleteSymbolKeyValueDictionary
rehashForConversion

"Private. Rehashes the receiver because the hash values of some of its keys
 may have changed."

| newSize |

(self class == ObsoleteSymbolKeyValueDictionary) 
  ifTrue: [
    (self containsOnlySymbols)
      ifTrue:  [ self convertToSymbolKeyValDict ]
      ifFalse: [ self convertToStringKeyValDict ].
    ].

newSize := (Integer _selectedPrimeGreaterThan: numElements) max: tableSize.
self rebuildTable: newSize.
%

category: 'Repository Conversion'
classmethod: ObsoleteSymbolKeyValueDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolKeyValueDictionary)
  ifTrue: [ ^ SymbolKeyValueDictionary ].

^ self.
%

