!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   LargeNegativeInteger, Integer, Number, Magnitude, Object.
!
!=========================================================================
removeallmethods ObsLargeNegativeInteger
removeallclassmethods ObsLargeNegativeInteger

category: 'Documentation'
classmethod: ObsLargeNegativeInteger
comment
^ '
 Instances of ObsLargeNegativeInteger represent negative integers whose values are
 greater than the maximum SmallInteger.  Each instance of ObsLargeNegativeInteger 
 is stored as an Array of bytes, where each double-byte pair represents 
 a base 32768 digit.  The first two bytes in that Array constitute 
 the least significant base 32768 digit, and the last two
 bytes are the most significant base 32768 digit.  Within each digit, the
 least significant byte is first, followed by the more significant byte.

 All instances are mutated in a read-only manner on fault into VM memory 
 to be instances of LargeNegativeInteger.  Send #convert to the instance to
 cause it to be written by the current transaction as an instance
 of LargeNegativeInteger. 
 See also Number>>convert .
'
%

