!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! file gscurrsession_2.gs
!===================================================================================

! fixed 42355
category: 'Initialization'
method: GsCurrentSession
initialize

" This method is executed once at Session initialization,
  after the ProcessorScheduler is initialized.  It is invoked from
  ProcessorScheduler>>_initialize:  if the GciLogin for this session
  did not include the login flag  GCI_CLIENT_DOES_SESSION_INIT .
  For logins specifying the flag GCI_CLIENT_DOES_SESSION_INIT ,
  the Gci application is responsible for invoking this methd by sending   
     GsCurrentSession initialize
  . 

  To install application specific initialization code, 
  use UserProfile>>loginHook: .

  Deprecated behavior: 
    This method may be modified to invoke application specific 
    initialization code.  

    Use extreme caution when testing modifications to this method.
    Errors in this method may unrecoverably disable commits and
    require restore from backup.  Prior to testing modifications,
    make a full backup of your system.  During testing, disable
    execution of application specific code for user SystemUser to
    allow recovery.
"

"Globals at: #IcuLibraryVersion checks are now done in C
 during VM initialization.  The value of IcuLibraryVersion determines
 the version of the libicu libraries loaded by the VM.

 The association (Globals associationAt: #IcuLibraryVersion) is 
 owned by SystemUser; its value should only be changed by SystemUser
 when no other user sessions are logged in, after which stone must 
 be shutdown and restarted.
"

"install a sessionMethodDictionary if GsPackagePolicy is enabled"
System myUserProfile isSystemProfile ifFalse:[
  GsPackagePolicy enabled
    ifTrue:[ GsPackagePolicy loadSessionMethodDictionary ]
    ifFalse:[ Unicode16 installUnicodeComparePrimitives ].

  "invoke the  method or block specified by  UserProfile >> loginHook: "
  userProfile _postLoginInitialize .
] ifTrue:[
  "SystemUser, GcUser, SymbolUser, HostAgentUser  use this code path, fix 47547"
  Unicode16 installUnicodeComparePrimitives .
].
^ self
%

! fixed 31100
category: 'Transaction Control'
method: GsCurrentSession
hasConflicts

"Determines, given the present state of the receiver, if any concurrency
 conflicts exist that would cause a subsequent commit operation to fail.
 Returns false if it finds no conflicts with other concurrent transactions.
 Returns true if it does find conflicts, which can then be examined by
 calling the System class>>transactionConflicts method.

 This method has meaningful results whether or not the receiver is currently
 running inside a transaction.

 Note:  Even if this method returns false, there is no guarantee that a
        subsequent commit operation will succeed.

 If certain updates have been made to reduced conflict objects, it cannot
 be determined until a commit is attempted whether or not a conflict exists.
 In the following cases, this method always returns true:

   * Any change to an RcPositiveCounter during the current session.
   * One or more removals from an RcIdentityBag during the current session.
   * A session performs both additions and removals from an RcQueue which
     it has not accessed in this transaction or previous transactions.
"

 | result systm |
 systm := System .
 result := systm _validateTransaction.
 result == -1 ifTrue:[ ^ false "read-only transaction" ].   
 result == 0 ifTrue: [ 
    ((GsBitmap newForHiddenSet: #RcReadSet) size) == 0
       ifTrue: [ ^ false ]
       ifFalse: [^ self _scanRedoLogForConflicts ]
  ] ifFalse: [
    result == 1
      ifTrue: [ ^ self _RcHasConflicts  ]
      ifFalse: [ ^ true "validationFailure" ]
  ].
  self halt: 'logic error' .
  ^ true "if we get here it is a logic error, but indicate conflicts exist"
%

