!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Description - Create the GcUser and SymbolUser accounts
! 
! Repository conversion - this file is used
!
!=======================================================================

! login as SystemUser
set user SystemUser pass swordfish
iferr 1 exit	
login 
iferr 1 where
iferr 2 stack

! for repository conversion, fixup default GsObjectSecurityPolicy of DataCurator
!  if needed

expectvalue /String
run
| dc seg2 convFromPrevious64bit report lf |
report := String new .
lf := Character lf .
convFromPrevious64bit := false .
seg2 := (Globals at:#SystemRepository) at: 2 .
dc := AllUsers detect: [ :x | x userId asString = 'DataCurator' ] .

"reset the DataCurator password so the sessionmethods.topaz step 
 can login as DataCurator ."
dc password:'swordfish' .
GsFile gciLogServer:'reset DataCurator password' .
report addAll:'reset DataCurator password'; add: lf .

(dc defaultObjectSecurityPolicy == nil or:[dc defaultObjectSecurityPolicy objectSecurityPolicyId == 1]) ifTrue:[
  convFromPrevious64bit := true .
  dc defaultObjectSecurityPolicy: seg2 .
  GsFile gciLogServer:'changed DataCurator defaultObjectSecurityPolicy' .
  report addAll:'changed DataCurator defaultObjectSecurityPolicy to GsObjectSecurityPolicy with objectSecurityPolicyId 2';
 	add: lf .
] ifFalse:[
  GsFile gciLogServer:'no change to DataCurator defaultObjectSecurityPolicy' .
  report addAll:'no change to DataCurator defaultObjectSecurityPolicy'; add: lf .
].
convFromPrevious64bit ifTrue:[
  AllUsers do:[:up | |uId |
    uId := up userId .
    GsFile gciLogServer:'processing ' , uId .
    (UserProfile isSpecialUserId: uId) ifFalse:[
      report addAll:'changed ', uId, ' defaultObjectSecurityPolicy to nil '; add: lf .
      "set for world-write to new objects per previous Gs64 release."
      up defaultObjectSecurityPolicy: nil . 
    ].
  ].
].
^ report
%


expectvalue /String
run
  " create GcUser account"
| gcUser newUser gcUserGlobals seg7 report lf |

gcUser := AllUsers detect: [ :x | x userId asString = 'GcUser' ] ifNone: [nil].
seg7 := (Globals at:#SystemRepository) at: 7 .
report := String new .
lf := Character lf .
gcUser ~~ nil ifTrue: [ | defSeg |
    "GcUser already exists. Set its password."
    gcUser password: 'swordfish'.
    defSeg := gcUser defaultObjectSecurityPolicy .
    defSeg == seg7 ifFalse:[ 
      gcUser defaultObjectSecurityPolicy: seg7 .
    ].
    seg7 isInvariant ifFalse:[
      seg7 owner: gcUser  .
    ].
    report addAll: 'GcUser already exists' ; add: lf .
] ifFalse: [
    "Create a new GcUser"
    newUser := UserProfile newWithUserId: 'GcUser'
                         password: 'swordfish'
                         defaultObjectSecurityPolicy: seg7 
                         privileges: #( #GarbageCollection)
                         inGroups: #() .

     seg7 owner: newUser  ;
	ownerAuthorization: #write ;
        worldAuthorization: #read . 

    " AllUsers add: newUser. --- no longer needed "

    " Put GcUser in SystemUser's UserGlobals "
    UserGlobals at: #GcUser put: newUser.

    " Put GcUser in DataCurator's UserGlobals"
    ((AllUsers userWithId: #DataCurator) resolveSymbol: #UserGlobals) value at: 
       #GcUser put: newUser.

    " Put GcUser in its own UserGlobals"
    gcUserGlobals := (newUser resolveSymbol: #UserGlobals) value.
    gcUserGlobals at: #GcUser put: newUser.
    report addAll: 'created GcUser' ; add: lf .
].
seg7 isInvariant ifFalse:[
  seg7 ownerAuthorization: #write ;
    worldAuthorization: #read .
  seg7 _name ifNil:[ seg7 name: 'GcUserObjectSecurityPolicy' ].

  "Gs64 v2.2, DataCurator needs permission to modify associations in 
   GcUser's userGlobals for running reclaimAll, etc. "
  seg7 group: (AllGroups at:'System') authorization: #write .
] ifTrue:[
   report addAll:'seg7 isInvariant, could not add System group write ';
	add: lf .
].
^ report
%

expectvalue /String
run
  " create SymbolUser account"
| symUser newUser theUg compilerSyms |

"Symbols used by initInitialSelectors in compile.c that don't have other refs.
 This array is an optimization to keeps these symbols from being garbage collected."

compilerSyms := #( #_rubyKindOf: #__inProtectedMode #_isScaledDecimal
		   #__callerEnvId #__threadRubyEnvId 
                   #signalBreakWith: #_doesNotUnderstand: #_mustBeBoolean 
                   #_gsReturnTos #_changeSegmentFrom:to: 
                   #_deadNscBeingGarbageCollected 
                   #_executeWith:with:with:with: #exclusive 
                   #_canonicalizeSymbolAt:oldSymbol:newSymbol: 
                   #_disableProtectedMode #super #_trapOop 
                   #EmptyString #EmptyArray 
                   #'whileFalse#1__' #'whileTrue#1__'
                   #'untilFalse#1__' #'untilTrue#1__'
                   #'value#0__' #'value#1__'
                  ) .

symUser := AllUsers detect: [ :x | x userId = 'SymbolUser' ] ifNone: [nil].
symUser ifNotNil: [
    "upgrade path, SymbolUser exists "
    symUser password: 'swordfish';
      defaultObjectSecurityPolicy: SystemObjectSecurityPolicy ;
      privileges: #( #GarbageCollection) .
  theUg := (symUser resolveSymbol: #UserGlobals) value.
  theUg at: #CompilerSymbols put: compilerSyms .
    ^ 'SymbolUser already exists, adjusted.'
] ifNil: [
    "Create a new SymbolUser profile " 
    newUser := UserProfile newWithUserId: 'SymbolUser'
                         password: 'swordfish'
                         defaultObjectSecurityPolicy: SystemObjectSecurityPolicy 
                         privileges: #( #GarbageCollection)
                         inGroups: #( ) .

    " AllUsers add: newUser. --- no longer needed "

    " Put SymbolUser in its own UserGlobals"
    theUg := (newUser resolveSymbol: #UserGlobals) value.
    
    theUg at: #SymbolUser put: newUser.
    theUg at: #PossibleDeadSymbols put: (Object _objectForOop: 248577).
    theUg at: #CompilerSymbols put: compilerSyms .
    ^ 'created SymbolUser'
]
%
commit

logout

set user GcUser pass swordfish
iferr 1 exit	
login 
iferr 1 where
iferr 2 stack

run
"set default admin and reclaim gem configs"
  System setDefaultAdminConfigs.
  System setDefaultReclaimConfigs.
  UserGlobals at: #defaultAdminConfigValues put: (System adminGemConfigs).
  UserGlobals at: #defaultReclaimConfigValues put: (System reclaimGemConfigs).
^ System commitTransaction
%

! preserve existing values in renameid parameters
expectvalue true
run
| oldOrDefault |
oldOrDefault  := UserGlobals at: #SweepWsUnionMaxThreads ifAbsent: [1].
UserGlobals at: #sweepWsUnionMaxThreads ifAbsentPut: [oldOrDefault].
oldOrDefault  := UserGlobals at: #SweepWsUnionPageBufferSize ifAbsent: [64].
UserGlobals at: #sweepWsUnionPageBufferSize ifAbsentPut: [oldOrDefault].
oldOrDefault  := UserGlobals at: #SweepWsUnionPercentCpuActiveLimit ifAbsent: [90].
UserGlobals at: #sweepWsUnionPercentCpuActiveLimit ifAbsentPut: [oldOrDefault].
^true
%

! remove all obsolete keys present

expectvalue true
run
UserGlobals removeKey: #jetReclaimMinDeadObjs otherwise: nil .
UserGlobals removeKey: #reclaimMaxPages otherwise: nil .
UserGlobals removeKey: #preheatCacheBeforeCommit otherwise: nil .
UserGlobals removeKey: #GemIOLimit otherwise: nil .
UserGlobals removeKey: #epochGcByteLimit otherwise: nil .
UserGlobals removeKey: #epochGcStatsEnabled otherwise: nil .
UserGlobals removeKey: #deferEpochReclaimThreshold otherwise: nil .
UserGlobals removeKey: #reclaimStatsEnabled otherwise: nil .
UserGlobals removeKey: #reclaimStats otherwise: nil .
UserGlobals removeKey: #epochGcEnabled otherwise: nil .
UserGlobals removeKey: #epochGcStats otherwise: nil .
UserGlobals removeKey: #reclaimDeadCommitLimit otherwise: nil .
UserGlobals removeKey: #objectTableCleanupIdleTime otherwise: nil .
UserGlobals removeKey: #promoteDeadLimit otherwise: nil .
UserGlobals removeKey: #deferPromoteDeadReclaimThreshold otherwise: nil .
UserGlobals removeKey: #coordinateJetGemCommits otherwise: nil .
UserGlobals removeKey: #sleepTimeBetweenTranlogWritesMs otherwise: nil .
UserGlobals removeKey: #reclaimDeadShadowPageThreshold otherwise: nil. 
UserGlobals removeKey: #dataPageBufferSize otherwise: nil.
UserGlobals removeKey: #reclaimSleepTime otherwise: nil.  
UserGlobals removeKey: #deferReclaimFreeSpaceThreshold otherwise: nil.
UserGlobals removeKey: #SweepWsUnionMaxThreads otherwise: nil.
UserGlobals removeKey: #SweepWsUnionPageBufferSize otherwise: nil.
UserGlobals removeKey: #SweepWsUnionPercentCpuActiveLimit otherwise: nil.
UserGlobals removeKey: #autoRefreshGcGemConfig otherwise: nil.
UserGlobals removeKey: #enableDebugging otherwise: nil.
UserGlobals removeKey: #verboseLogging otherwise: nil.
UserGlobals removeKey: #defaultValues otherwise: nil.

^true
%

expectvalue true
run
| oldValueInSeconds |
oldValueInSeconds := UserGlobals at: #sleepTimeBetweenReclaim otherwise: 0 .
oldValueInSeconds _isSmallInteger
  ifFalse:[oldValueInSeconds := 0].
"43521 - don't overwrite the existing value, if any!"
UserGlobals at: #sleepTimeBetweenReclaimMs ifAbsentPut: [oldValueInSeconds * 1000].
UserGlobals removeKey: #sleepTimeBetweenReclaim otherwise: nil .
^true
%

! Now install default values for all new keys, leave old values alone.
!   changed default for epochGcTimeLimit with fix 34388 
expectvalue true
run
UserGlobals at: #reclaimMinPages ifAbsentPut: [40]. 
UserGlobals at: #reclaimMinFreeSpaceMb ifAbsentPut: [0].
UserGlobals at: #sleepTimeBetweenReclaimMs ifAbsentPut: [0].
UserGlobals at: #sleepTimeWithCrBacklogMs ifAbsentPut: [0].
UserGlobals at: #reclaimDeadEnabled  ifAbsentPut: [true].
UserGlobals at: #objsMovedPerCommitThreshold ifAbsentPut: [20000].
UserGlobals at: #deadObjsReclaimedCommitThreshold ifAbsentPut: [20000]. 
UserGlobals at: #maxTransactionDuration ifAbsentPut: [300].
UserGlobals at: #deferReclaimCacheDirtyThreshold ifAbsentPut: [75].
UserGlobals at: #epochGcTimeLimit ifAbsentPut: [ 3600 ]. 
UserGlobals at: #epochGcTransLimit ifAbsentPut: [5000]. 
UserGlobals at: #epochGcMaxThreads ifAbsentPut: [1].
UserGlobals at: #epochGcPercentCpuActiveLimit ifAbsentPut: [90].
UserGlobals at: #sweepWsUnionMaxThreads ifAbsentPut: [1].
UserGlobals at: #sweepWsUnionPageBufferSize ifAbsentPut: [64].
UserGlobals at: #sweepWsUnionPercentCpuActiveLimit ifAbsentPut: [90].
UserGlobals at: #saveWriteSetUnionToFile ifAbsentPut: [false]. "Request 43337"
UserGlobals at: #reclaimVerboseLogging ifAbsentPut: [false].
UserGlobals at: #adminVerboseLogging ifAbsentPut: [false].
^ true
%
commit

expectvalue /String
run
" fix 46009 , install/upgrade to a power of 2"
| x v |
x := System getAdminConfig: #epochGcPageBufferSize.
v := 64 .
x _isSmallInteger ifTrue:[
  [ v < x and:[ v < 512] ] whileTrue:[  
     v := v * 2 .
  ].
].  
UserGlobals at: #epochGcPageBufferSize put: v .
^ 'found ' , x asString , '  installed ' , v asString
%

stack
commit

logout
