! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id$
!
! ========================================================================

expectvalue %String
run
Array _newKernelSubclass: #ErrorDescription
  instVarNames: #(#categoryOop #number #contextOop #message #fatal 
                  #gciInterface )
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #() 
  reservedOop: 921
%

# Forward reference needed to GciInterface
run
Globals at: #GciInterface ifAbsent: [Globals at: #GciInterface put: nil].
true
%

! Remove existing behavior from ErrorDescription
removeallmethods ErrorDescription
removeallclassmethods ErrorDescription

! ------------------- Class methods for ErrorDescription
category: 'Documentation'
classmethod:
comment
  ^'ErrorDescription is used by the class GciInterface. 
Instances describe errors returned from a remote VM.

Constraints:
	categoryOop: Integer
	number: Integer
	contextOop: Object
	message: String
	fatal: Boolean
	gciInterface: Object'
%
! ------------------- Instance methods for ErrorDescription
category: 'Accessing'
method: ErrorDescription
category

   "To match GciErrSType."
   ^categoryOop
%
category: 'Accessing'
method: ErrorDescription
categoryOop

   "Return the value of the instance variable 'categoryOop'."
   ^categoryOop
%
category: 'Accessing'
method: ErrorDescription
context

   "To match GciErrSType."
   ^contextOop
%
category: 'Accessing'
method: ErrorDescription
contextOop

   "Return the value of the instance variable 'contextOop'."
   ^contextOop
%
category: 'Accessing'
method: ErrorDescription
fatal

   "Return the value of the instance variable 'fatal'."
   ^fatal
%
category: 'Testing'
method: ErrorDescription
isBreakPoint

"Return whether the error is due to a breakpoint."

categoryOop == nil
  ifTrue: [^false].
GemStoneError == (GciInterface _objectForOop: categoryOop)
  ifFalse: [^false].
^ (number == (ErrorSymbols at: #rtErrStackBreakpoint) or:
  [number == (ErrorSymbols at: #rtErrStep) or:
  [number == (ErrorSymbols at: #rtErrCodeBreakpoint)]])
%
category: 'Testing'
method: ErrorDescription
isSoftBreak

"Return whether the error is due to a soft break."

categoryOop == nil
  ifTrue: [^false].
GemStoneError == (GciInterface _objectForOop: categoryOop)
  ifFalse: [^false].
^ number == (ErrorSymbols at: #rtErrSoftBreak)
%
category: 'Testing'
method: ErrorDescription
isPause

"Return whether the error is due to a soft break."

categoryOop == nil
  ifTrue: [^false].
GemStoneError == (GciInterface _objectForOop: categoryOop)
  ifFalse: [^false].
^ number == (ErrorSymbols at: #rtErrPause)
%
category: 'Accessing'
method: ErrorDescription
message

   "Return the value of the instance variable 'message'."
   ^message
%
category: 'Accessing'
method: ErrorDescription
number

   "Return the value of the instance variable 'number'."
   ^number
%
category: 'Accessing'
method: ErrorDescription
printString
  "Display the receiver"

| s |

s := String new.
s add: self class name.
s add: '('.

s add: 'category=' ; add: categoryOop printString ; add: ', '.
s add: 'number=' ; add: number printString ; add: ', '.
s add: 'context=' ; add: contextOop printString ; add: ', '.

message == nil ifTrue:[s add: 'message=none' ]
	ifFalse: [s add: 'message="' ; add: message printString ; add: '", '].
s add: 'fatal=' ; add: fatal printString.

s add: ')'.
^s
%

method:
asString
  ^ self printString
%
