!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: equalityindexspec.gs 19139 2008-05-30 23:48:14Z stever $
!
! Superclass Hierarchy:
!   EqualityIndexSpecification,
!   AbstractIndexSpecification,
!   Object.
!
!=========================================================================

! class created in idxclasses.topaz

! Remove existing behavior from EqualityIndexSpecification
doit
EqualityIndexSpecification removeAllMethods.
EqualityIndexSpecification class removeAllMethods.
true
%

! ------------------- Class methods for EqualityIndexSpecification
category: 'For Documentation Installation only'
classmethod: EqualityIndexSpecification
installDocumentation

self comment:
'The class EqualityIndexSpecification provides details for specifying an equality index.'.
%

! ------------------- Instance methods for EqualityIndexSpecification
category: 'accessing'
method: EqualityIndexSpecification
equalityIndexClass
  ^ self legacyIndex
    ifTrue: [ RangeEqualityIndex ]
    ifFalse: [ GsRangeEqualityIndex ]
%
category: 'accessing'
method: EqualityIndexSpecification
indexType

	^#equality
%
category: 'accessing'
set compile_env: 0
method: EqualityIndexSpecification
removeIndexFrom: anNsc
  (self isIndexedOn: anNsc)
    ifTrue: [ anNsc removeEqualityIndexOn: self path ]
%

! delete EqualityIndexSpecification createIndexOn:

category: 'accessing'
set compile_env: 0
method: EqualityIndexSpecification
indexTypePrintString
  ^ 'equalityIndex'
%

category: 'accessing'
set compile_env: 0
method: EqualityIndexSpecification
_createIndex
  | index |
  index := self equalityIndexClass
    newWithLastElementClass: self lastElementClass.
  self legacyIndex
    ifFalse: [ index options: self options ].
  ^ index
%
category: 'private'
set compile_env: 0
method: EqualityIndexSpecification
_validateLastElementClassOn: anNsc
  | aClass |
  aClass := self lastElementClass.
  aClass _validateClass: Behavior.
  ((aClass canUnderstand: #'<=')
    or: [ aClass == Boolean or: [ aClass == UndefinedObject ] ])
    ifFalse: [ anNsc _error: #'rtErrBagClassDoesNotSupportRangeOperators' args:{aClass} ]
%
