!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ClusterBucketArray, Array, SequenceableCollection, Collection, Object.
!
!=========================================================================

removeallmethods ClusterBucketArray
removeallclassmethods ClusterBucketArray

category: 'For Documentation Installation only'
classmethod: ClusterBucketArray
installDocumentation

self comment:
'A ClusterBucketArray is an Array whose elements are instances of ClusterBucket.

 There is one instance of ClusterBucketArray in a fresh GemStone repository.  It
 can be accessed via the Globals dictionary using the following GemStone
 Smalltalk statement:

 Globals at: #AllClusterBuckets.

 GemStone uses AllClusterBuckets to translate clusterIds to cluster bucket
 objects:

 classmethod: ClusterBucket
 bucketWithId: aSmallPositiveInt
   ^ AllClusterBuckets at: aSmallPositiveInt
 %

 AllClusterBuckets has a reserved object identifier, to facilitate efficient
 access of the Array from within the object manager.  Therefore, a special C
 constant, OOP_ALL_CLUSTER_BUCKETS, is defined in the gcioop.ht header file to
 permit access to it from C.

Constraints:
	[elements]: ClusterBucket'.
%

category: 'Clustering'
method: ClusterBucketArray
clusterInBucket: aClusterBucketOrId

"Instances of ClusterBucketArray, especially AllClusterBuckets
 must always be clustered in the default bucket."

^ super clusterInBucket: 1
%

category: 'Clustering'
method: ClusterBucketArray
cluster

"Instances of ClusterBucketArray, especially AllClusterBuckets
 must always be clustered in the default bucket."

^ super clusterInBucket: 1
%

