! file: class2.gs
! $Id$

!  this file is input at the end of filein after all classes are defined

category: 'Private'
method: Class
_sortedClassVarNames

"Returns a sorted list of class variable names. "

 | res |
 res := SortedCollection new .
 classVars ifNotNil:[ res addAll: classVars keys ].
 ^ res
%

category: 'Private'
method:
_clearCachedOrganizer

   ClassOrganizer clearCachedOrganizer  
%


category: 'Private'
method: Class
_validateInstancesPersistent

"check that it is legal to make instances of the receiver 
 persistent."

| list |
list := { 
  IdentityKeySoftValueDictionary . IdentitySoftCollisionBucket . 
  KeySoftValueDictionary . SoftCollisionBucket . SoftReference . Semaphore
 }.
1 to: list size do:[ :n |  | aCls |
  aCls := list at: n .
  aCls == self ifTrue:[ 
    ImproperOperation new reason: #rtErrSuperclassIsNP; 
	details: 'instances of this class are always non-persistent';
	object: self ; signal .
    ^ false
  ]
].
^ true
%
category: 'Dynamic Literal Variables'
classmethod:
classVariablesAssociationClass: aClass
  | tmps |
  tmps := SessionTemps current .
  (aClass == nil or:[ aClass == SymbolAssociation]) ifTrue:[
     GsNMethod dynamicLiteralVariables: false .
     ^ tmps removeKey:#ClassVariablesAssociationClass otherwise: nil .
  ] ifFalse:[ | prev |
    (aClass _subclassOf: SymbolAssociation) ifFalse:[  "ignore classHistory"
      aClass _error: #rtErrNotASubclassOf args:{ aClass }
    ].
    GsNMethod dynamicLiteralVariables: true .
    prev := tmps at:#ClassVariablesAssociationClass otherwise: nil .
    tmps at:#ClassVariablesAssociationClass put: aClass .
    ^ prev
  ]
%

category: 'Subclass Creation'
method:
_makeClassVarDict: anArrayOfClassVars

"Turns Array of class variable names into a SymbolDictionary.
 Returns nil if anArrayOfClassVars is empty or nil. "

| newDict numCvs |
self _validatePrivilege ifTrue:[
  anArrayOfClassVars ifNotNil:[
    anArrayOfClassVars _isArray ifFalse:[ 
      (anArrayOfClassVars _validateClass: Array) ifFalse:[ ^ nil ].
    ].
    (numCvs := anArrayOfClassVars size) ~~ 0 ifTrue:[ | assocClass  |
      newDict := SymbolDictionary new.
      assocClass := SessionTemps current at:#ClassVariablesAssociationClass otherwise: SymbolAssociation.
      1 to: numCvs do: [:index|
        | aVarName aSym definingClass |
	aVarName := anArrayOfClassVars at: index .
        (aVarName _isOneByteString or:[ aVarName _validateClass: CharacterCollection]) ifTrue:[
	  aSym := aVarName asSymbol .
	  aSym validateIsIdentifier "fix bug 9666" .
	  definingClass := self _classDefiningClassVar: aSym .  "fix bug 10480"
	  definingClass ifNotNil:[
            LookupError new object: definingClass; key: aSym ; reason: #classErrClassVarNameExists ;
		details: 'class variable already exists'; signal
	  ] ifNil:[
	    newDict addAssociation:( assocClass newWithKey: aSym value: nil )
	  ]
        ].
      ].
    ].
  ].
].
^ newDict .
%

