!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   BtreeRangeComparisonQuerySpec, BtreeComparisonQuerySpec, BtreeQuerySpec,
!   Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods BtreeRangeComparisonQuerySpec
removeallclassmethods BtreeRangeComparisonQuerySpec

category: 'For Documentation Installation only'
classmethod: BtreeRangeComparisonQuerySpec
installDocumentation

self comment:
'BtreeRangeComparisonQuerySpec is an concrete class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreeNode that satisfy a particular query
 based on comparisons between two values.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.'.
%

! ------------------- Class methods for BtreeRangeComparisonQuerySpec
category: 'Instance Creation'
classmethod: BtreeRangeComparisonQuerySpec
key: aKey selector: aSelector and: aKey2 selector: aSelector2

| new |
new := self new key: aKey selector: aSelector.
new key2: aKey2 selector2: aSelector2.
^new
%
! ------------------- Instance methods for BtreeRangeComparisonQuerySpec
category: 'Updating'
method: BtreeRangeComparisonQuerySpec
key2: aKey2 selector2: aSelector2

key2 := aKey2.
opCode2 := self operationSelectors indexOf: aSelector2.
%
category: 'Querying'
method: BtreeRangeComparisonQuerySpec
_addValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection
  | sel1 sel2 |
  sel1 := self performSelector: opCode.
  sel2 := self performSelector: opCode2.
  startIndex to: endIndex by: entrySize do: [ :i | 
    | aKey |
    aKey := aLeafNode _basicAt: i + 1.
    (self compare: aKey using: sel1 and: sel2)
      ifTrue: [ collection add: (aLeafNode _basicAt: i) ] ]
%
category: 'Querying'
method: BtreeRangeComparisonQuerySpec
_traverseValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex previous: previousValue into: collection
  | val prevVal aKey sel1 sel2 |
  sel1 := self performSelector: opCode.
  sel2 := self performSelector: opCode2.
  prevVal := previousValue.
  startIndex to: endIndex by: entrySize do: [ :i | 
    aKey := aLeafNode _basicAt: i + 1.
    val := aLeafNode _basicAt: i.
    ((self compare: aKey using: sel1 and: sel2) and: [ val ~~ prevVal ])
      ifTrue: [ 
        rangeIndex
          _addAllFor: val
          into: collection
          offset: offset
          pathTerm: pathTerm ].
    prevVal := val ].
  ^ prevVal
%
category: 'Comparing'
set compile_env: 0
method: BtreeRangeComparisonQuerySpec
compare: entry using: selector1 and: selector2
  ^ (entry perform: selector1 with: key)
    and: [ entry perform: selector2 with: key2 ]
%
category: 'Comparing'
method: BtreeRangeComparisonQuerySpec
compareKey: entry
  ^ (entry perform: (self performSelector: opCode) with: key)
    and: [ entry perform: (self performSelector: opCode2) with: key2 ]
%
category: 'Querying'
method: BtreeRangeComparisonQuerySpec
_addRootObjectsFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection
  | sel1 sel2 |
  sel1 := self performSelector: opCode.
  sel2 := self performSelector: opCode2.
  startIndex to: endIndex by: entrySize do: [ :i | | aKey |
    aKey := aLeafNode keyAt: i.
    (self compare: aKey using: sel1 and: sel2)
      ifTrue: [ collection add: (aLeafNode rootObjectAt: i) ] ]
%

