!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   BtreeComparisonQuerySpec, BtreeQuerySpec,
!   Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods BtreeComparisonQuerySpec
removeallclassmethods BtreeComparisonQuerySpec

category: 'For Documentation Installation only'
classmethod: BtreeComparisonQuerySpec
installDocumentation

self comment:
'BtreeComparisonQuerySpec is an concrete class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreeNode that satisfy a particular query
 based on a comparison of a single set of values.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.'.

%

! ------------------- Class methods for BtreeComparisonQuerySpec
category: 'Instance Creation'
classmethod: BtreeComparisonQuerySpec
key: aKey selector: aSelector

^self new key: aKey selector: aSelector
%
! ------------------- Instance methods for BtreeComparisonQuerySpec
category: 'Updating'
method: BtreeComparisonQuerySpec
key: aKey selector: aSelector

key := aKey.
opCode := self operationSelectors indexOf: aSelector.
%
category: 'Accessing'
method: BtreeComparisonQuerySpec
operationSelectors

"Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation integer for each predicate entry in the receiver."

^ #( #< #> #= #== #<= #>= #~= #~~)
%
category: 'Accessing'
method: BtreeComparisonQuerySpec
performSelector: anOpCode

^self performSelectors at: anOpCode
%
category: 'Accessing'
method: BtreeComparisonQuerySpec
performSelectors

"Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

^ #( #_idxForCompareLessThan: 
    #_idxForCompareGreaterThan: 
    #_idxForCompareEqualTo:  
    #==
    #_idxForCompareLessThanOrEqualTo: 
    #_idxForCompareGreaterThanOrEqualTo: 
    #_idxForCompareNotEqualTo: 
    #~~
  )
%
category: 'Querying'
method: BtreeComparisonQuerySpec
_addValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection
  | sel |
  sel := self performSelector: opCode.
  startIndex to: endIndex by: entrySize do: [ :i | 
    (self compare: (aLeafNode _basicAt: i + 1) using: sel)
      ifTrue: [ collection add: (aLeafNode _basicAt: i) ] ]
%
category: 'Querying'
method: BtreeComparisonQuerySpec
_traverseValuesFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex previous: previousValue into: collection
  | val prevVal aKey sel |
  sel := self performSelector: opCode.
  prevVal := previousValue.
  startIndex to: endIndex by: entrySize do: [ :i | 
    aKey := aLeafNode _basicAt: i + 1.
    val := aLeafNode _basicAt: i.
    ((self compare: aKey using: sel) and: [ val ~~ prevVal ])
      ifTrue: [ 
        rangeIndex
          _addAllFor: val
          into: collection
          offset: offset
          pathTerm: pathTerm ].
    prevVal := val ].
  ^ prevVal
%
category: 'Comparing'
set compile_env: 0
method: BtreeComparisonQuerySpec
compare: entry using: selector
  ^ entry perform: selector with: key
%
category: 'Accessing'
set compile_env: 0
method: BtreeComparisonQuerySpec
collator
  ^ nil
%
category: 'Accessing'
set compile_env: 0
method: BtreeComparisonQuerySpec
collator: ignored
  "ignored"

  
%
category: 'Comparing'
method: BtreeComparisonQuerySpec
compareKey: entry
  ^ entry perform: (self performSelector: opCode) with: key
%
category: 'Querying'
method: BtreeComparisonQuerySpec
_addRootObjectsFrom: aLeafNode entrySize: entrySize start: startIndex end: endIndex into: collection
  | sel |
  sel := self performSelector: opCode.
  startIndex to: endIndex by: entrySize do: [ :i |
    (self compare: (aLeafNode keyAt: i) using: sel)
      ifTrue: [ collection add: (aLeafNode rootObjectAt: i) ] ]
%

