!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   Object, GsUuidV4
!
!=========================================================================

expectvalue %Boolean
run
(Globals at: #GsUuidV4 otherwise: nil) ifNil: [
  Object _newKernelByteSubclass: 'GsUuidV4' 
            classVars: #() 
            poolDictionaries: { } 
            inDictionary: Globals 
            options: #( instancesInvariant )
            reservedOop: nil.
  ^ true
] ifNotNil:[
  ^ false
]  
%

removeallmethods GsUuidV4
removeallclassmethods GsUuidV4
set class GsUuidV4

category: 'For Documentation Installation only'
classmethod: GsUuidV4
installDocumentation

self comment:
'GsUuidV4 is an implementation of a version 4 UUID as specified in RFC 4122,
 A Universally Unique IDentifier (UUID) URN Namespace. UUIDs are generated
 randomly using the secure OpenSSL random number generator.

 Instances of GsUuidV4 are invariant and therefore cannot be modified.'
%

category: 'Instance Creation'
classmethod: GsUuidV4
new
^ self _basicNew
%

category: 'Instance Creation'
classmethod: GsUuidV4
fromString: aUuidString

"Returns a new instance of the receiver. Raises an exception if aUuidString
 is not a valid UUID version 4 string in the following format:

   xxxxxxxx-xxxx-4xxx-Vxxx-xxxxxxxxxxxx

 where x is any valid lower-case hex digit and V is one of 8,9,a or b.

 See RFC 4122 for details"

^ self _oneArgClassPrim: aUuidString opCode: 1
%

category: 'Instance Creation'
classmethod: GsUuidV4
new: aSize
^ self shouldNotImplement: #new:
%

! must allow _basicNew: aSize to work or object passivate/activate breaks

category: 'Updating'
method: GsUuidV4
size: anInteger
^ self shouldNotImplement: #size:
%

category: 'Updating'
method: GsUuidV4
_basicSize: anInteger
^ self shouldNotImplement: #_basicSize:
%

category: 'Comparing'
method:
= anotherUuid

"Returns true if all of the following conditions are true, otherwise
returns false.

 1.  The receiver and anotherUuid are of the same class.
 2.  The two objects are the same size.
 3.  The corresponding elements of the receiver and anotherUuid
     are equal."

<primitive: 613>
self _primitiveFailed: #= .
self _uncontinuableError
%

category: 'Comparing'
method:
hash

"Returns a positive SmallInteger based on the byte contents of the receiver.
 Uses a case-sensitive string hash algorithm.
 The algorithm implemented is described in:

 [Pearson 90]
 Pearson, Peter K., Fast Hashing of Variable-Length Text Strings,
 Communications of the ACM 33, 6, (June 1990), 677-680."

<primitive: 31>
self _primitiveFailed: #hash .
self _uncontinuableError
%

category: 'Accessing'
method:
version
"Answer the UUID version of this object.  See RFC 4122 for UUID version
 definitions."
 
 ^ 4
%

category: 'Private'
classmethod: GsUuidV4
_zeroArgClassPrim: opCode

"
opCode	kind	method
===============================
1	class	_basicNew
2	inst	asString
3       inst    asInteger
===============================
"

<primitive: 1122>
opCode _validateClass: SmallInteger .
self _primitiveFailed: #_zeroArgClassPrim: .
self _uncontinuableError
%

category: 'Private'
method: GsUuidV4
_zeroArgInstancePrim: opCode

"
opCode	kind	method
===============================
1	class	_basicNew
2	inst	asString
3       inst    asInteger
===============================
"

<primitive: 1122>
opCode _validateClass: SmallInteger .
self _primitiveFailed: #_zeroArgInstancePrim: .
self _uncontinuableError
%

category: 'Private'
classmethod: GsUuidV4
_basicNew

^self _zeroArgClassPrim: 1
%

category: 'Converting'
method:
asString
"Returns a 36 character string representing the receiver formatted as specified in
 RFC 4122."
 
^ self _zeroArgInstancePrim: 2 .
%

category: 'Private'
classmethod: GsUuidV4
_oneArgClassPrim: arg opCode: opCode

"
opCode	kind	method
===============================
1	class	fromString:
2       inst	<
===============================
"

<primitive: 1123>
opCode _validateClass: SmallInteger .
self _primitiveFailed: #_oneArgClassPrim: .
self _uncontinuableError
%

category: 'Private'
method: GsUuidV4
_oneArgInstancePrim: arg opCode: opCode

"
opCode	kind	method
===============================
1	class	fromString:
2	inst    <
===============================
"

<primitive: 1123>
opCode _validateClass: SmallInteger .
self _primitiveFailed: #_oneArgClassPrim: .
self _uncontinuableError
%

category: 'Comparing'
method: GsUuidV4
< aUuid

"Answer a Boolean indicating if the receiver is less than
 aUuid. Raises an exception if aUuid is not a valid instance
 of GsUuidV4 or a subclass."
 
^self _oneArgInstancePrim: aUuid opCode: 2
%

category: 'Comparing'
method: GsUuidV4
<= aUuid
"Answer a Boolean indicating if the receiver is less than
 or equal to aUuid. Raises an exception if aUuid is not a valid instance
 of GsUuidV4 or a subclass."

^ (self = aUuid) or:[self < aUuid]
%

category: 'Comparing'
method: GsUuidV4
> aUuid
"Answer a Boolean indicating if the receiver is greater than
 aUuid. Raises an exception if aUuid is not a valid instance
 of GsUuidV4 or a subclass."
 
^ aUuid < self
%

category: 'Comparing'
method: GsUuidV4
>= aUuid
"Answer a Boolean indicating if the receiver is greater than
 or equal to aUuid. Raises an exception if aUuid is not a valid instance
 of GsUuidV4 or a subclass."
 
^ (self = aUuid) or:[self > aUuid]
%
category: 'Printing'
method: GsUuidV4
printOn: aStream
"Prints a representation of the receiver onto aStream."
 
^ aStream nextPutAll: 'an UUID(';
  	  nextPutAll: self asString ;
	  nextPut: $) ;
	  yourself
%

category: 'Printing'
method: GsUuidV4
printString
"Returns a 36 character string representing the receiver formatted as specified in
 RFC 4122."
 
^ self asString
%

category: 'Converting'
method: GsUuidV4
asInteger

^ self _zeroArgInstancePrim: 3
%

category: 'Private - Converting'
method: GsUuidV4
asInteger2
"Smalltalk implementation of the asInteger method."

| sum |
sum := 0 .
1 to: 16 do:[:n| sum := sum + ((self at: n) * (256 raisedTo: (n - 1)))].
^sum
%

category: 'Converting'
method: GsUuidV4
asString36
"Encode the receiver as a base 36 string using 0-9 and lowercase a-z.
 Returns an instance of String."

^ (self asInteger printStringRadix: 36) asLowercase
%

category: 'Storing and Loading'
method: GsUuidV4
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into the receiver."

super loadFrom: passiveObj .
self immediateInvariant .
^ self
%

category: 'Copying'
method: GsUuidV4
postCopy
self immediateInvariant .
^ self
%
