#! /bin/bash
#set -x
#=========================================================================
# Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
#
# Name - sslcommon.sh
#
#  Setup file for SSL scripts
#  GsSecureSocket example code and secure full backup examples.
#
#  This script is provided as an example only.
#
# $Id$
#
#=========================================================================

my_name=`basename $0`
OK=0

cleanupFiles(){
    if [ "$1" != "" ]; then
      echo "Removing $1"
      rm -f $1 >/dev/null 2>&1
    fi
}


checkForError(){
    if [ $? -ne 0 ]; then
	echo "Previous step failed"
	cleanupFiles $1
	exit 1
    fi
}

ensureFileExists(){
    if [ ! -f $1 ]; then
	echo "[Error]: File $1 does not exist"
	cleanupFiles $2
	exit 1
    fi
}

ensureFileDoesNotExist(){
    if [ -f $1 ]; then
	echo "[Error]: File $1 already exists"
	cleanupFiles $2
	exit 1
    fi
}


while [ 1 -eq 1 ]
do

    if [ ! -d $GEMSTONE ]; then
    echo "[Error]: GEMSTONE env variable must be set"
    break
  fi

  # warning: openssl.conf needs this env var!!
  # Compute the base directory from where this script is located.
  # Normally that will be $GEMSTONE/examples/openssl
  FULL_NAME=`readlink -f $0`
  SSL_BASE_DIR=`dirname $FULL_NAME`
  if [ ! -d $SSL_BASE_DIR ]; then
    echo "[Error]: $SSL_BASE_DIR does not exist or is not a directory"
    break
  fi
  export SSL_BASE_DIR

# config file used for configuring openssl
  export OPENSSL_CONF=$SSL_BASE_DIR/config/openssl.cnf
  if [ ! -f $OPENSSL_CONF ]; then
    echo "OpenSSL config file $OPENSSL_CONF cannot be accessed"
    break
  fi
  OPENSSL=$GEMSTONE/bin/openssl
  if [ ! -f $OPENSSL ]; then
      echo "Could not find openssl executable in \$GEMSTONE/bin"
      break
  fi
  
  OK=1
  break
done
