!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: symbola.gs,v 1.5 2008-01-09 22:50:19 stever Exp $
!
! Superclass Hierarchy:
!   SymbolAssociation, Association, Object.
!
!=========================================================================

removeallmethods SymbolAssociation
removeallclassmethods SymbolAssociation

category: 'For Documentation Installation only'
classmethod: SymbolAssociation
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'A SymbolAssociation is an Association whose key is constrained to be a
 canonical symbol (Symbol or DoubleByteSymbol).'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Private'
method: SymbolAssociation
_resolveRcConflictsWith: conflictObjects

"A logical write-write conflict has occurred on the receiver.  This
 may have occurred due to artificially placing the receiver in the write
 set when a subclass re-implemented this method (this is done to maintain
 cache coherency. See if the state has changed in this transaction.  If
 so, then it is a valid conflict (and returns false); otherwise returns true."

| preAbortValue |
preAbortValue := value.
self _selectiveAbort.
^ value == preAbortValue
%

!gemstone64, reimplement key: to enforce constraints
category: 'Accessing'
method: SymbolAssociation
key: aKey

"Sets the object aKey as the key of the receiver, after checking
 constraints."

 (aKey isKindOf: Symbol) ifTrue:[ 
   key := aKey .  
 ] ifFalse:[
   System signal: 2107
     args: #[ self , aKey, Symbol, aKey class]
     signalDictionary: (Globals at: #GemStoneError) .
   self _uncontinuableError .
 ]
%

!gemstone64, reimplement key:value: to enforce constraints
category: 'Updating'
method: SymbolAssociation
key: aKey value: aValue


"Sets the object aKey as the key of the receiver, and the object aValue as the
 value of the receiver."

 self key: aKey .  "message send to enforce constraints"
 self value: aValue .
%
