!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: smallfloat.gs,v 1.7 2008-01-09 22:50:18 stever Exp $
!
! Superclass Hierarchy:
!   SmallFloat, BinaryFloat, Number, Magnitude, Object.
!
! class SmallFloat created in floatclasses.gs
!=========================================================================

removeallmethods SmallFloat
removeallclassmethods SmallFloat

category: 'For Documentation Installation only'
classmethod: SmallFloat
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'This class represents 4 byte binary floating point numbers, as defined in IEEE
 standard 754.
 
 This class is deprecated.  
 Most numeric operations will return instances of SmallDouble or Float .

 You may not create subclasses of SmallFloat.' .
doc documentClassWith: txt.

txt := (GsDocText new) details:
'Float status flags, exception handlers, and non-default rounding modes are
 maintained only for a single execution of the virtual machine, and are cleared
 when a new invocation of the virtual machine begins.'.
doc documentClassCategory: #'Exception Handling' with: txt.

self description: doc.
%

category: 'Converting'
method: SmallFloat
asSmallFloat

"Returns the receiver."

^ self
%

category: 'Converting'
method: SmallFloat
asFloat

"Returns a SmallDouble or Float with the same value as the receiver."

<primitive: 154>
^ self _primitiveFailed: #asFloat
%

category: 'Converting'
method: SmallFloat
_coerce: aNumber

"Returns an instance of SmallFloat with the same value as 'aNumber'."

"This method must be defined by all subclasses of Number."

^ aNumber asFloat asSmallFloat
%

category: 'Accessing'
method: SmallFloat
denominator

"Returns the denominator of a Fraction representing the receiver."

^ self asFloat denominator
%

category: 'Accessing'
method: SmallFloat
numerator

"Returns the numerator of a Fraction representing the receiver."

^ self asFloat numerator
%

! sign - inherit from Number
! negative - inherit from Number

category: 'Accessing'
method: SmallFloat
asFraction

"Returns a Fraction that represents the receiver.  If the receiver is a NaN,
 or Infinity, returns the receiver."

^ self asFloat asFraction
%

category: 'Converting'
method: SmallFloat
_generality

"Returns the integer that represents the ordering of the receiver in the
 generality hierarchy."

"Reimplemented from Number"

^ 80
%

category: 'Truncation and Rounding'
method: SmallFloat
truncated

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located.  In particular, returns the receiver
 if the receiver is an integer."

^ self asFloat truncated
%

category: 'Arithmetic'
method: SmallFloat
* aNumber

"Multiply the receiver by aNumber and returns the result."

^ self asFloat * aNumber
%

category: 'Arithmetic'
method: SmallFloat
- aNumber

"Returns the difference between the receiver and aNumber."

^ self asFloat - aNumber
%

category: 'Arithmetic'
method: SmallFloat
+ aNumber

"Returns the sum of the receiver and aNumber."

^ self asFloat + aNumber
%

category: 'Arithmetic'
method: SmallFloat
/ aNumber

"Divide the receiver by aNumber and returns the result."

^ self asFloat / aNumber
%

category: 'Comparing'
method: SmallFloat
_compare: aNumber opcode: opcode

"Private."

"opcode function
   0     =
   1     ~=
   2     <
   3     <= 

 The primitive returns nil if the receiver and argument are not
 comparable, and the sender must then retry the compare."

<primitive: 176>
^ self _primitiveFailed: #_compare 
%

category: 'Comparing'
method: SmallFloat
~= aNumber

"Returns true if the receiver is not equal to aNumber; returns false
 otherwise."

| result |
result := self _compare: aNumber opcode: 1 .
result ~~ nil ifTrue:[ ^ result ] .
^ self asFloat ~= aNumber
%

category: 'Comparing'
method: SmallFloat
< aNumber

"Returns true if the receiver is less than aNumber; returns false otherwise."

| result |
result := self _compare: aNumber opcode: 2 .
result ~~ nil ifTrue:[ ^ result ] .
^ self asFloat < aNumber

%

category: 'Comparing'
method: SmallFloat
<= aNumber

"Returns true if the receiver is less than or equal to a aNumber;
 returns false otherwise."

| result |
result := self _compare: aNumber opcode: 3 .
result ~~ nil ifTrue:[ ^ result ] .
^ self asFloat <= aNumber 
%

category: 'Comparing'
method: SmallFloat
= aNumber

"Returns true if the receiver is equal to aNumber; returns false otherwise."

| result |
result := self _compare: aNumber opcode: 0 .
result ~~ nil ifTrue:[ ^ result ] .
^ self asFloat = aNumber 
%

! hash inherited from Number

category: 'Indexing Support'
method: SmallFloat
_isNaN

"Returns whether the receiver is quiet NaN or signaling NaN.
 This method is only to be used by the indexing subsystem."

^ self _getKind > 4
%

category: 'Accessing'
method: SmallFloat
_getKind

"Returns an integer, 1...6, for the kind of the receiver."

<primitive: 178>

^ self _primitiveFailed: #_getKind
%

category: 'Formatting'
method: SmallFloat
asStringUsingFormat: anArray

"Returns a String corresponding to the receiver, using the format specified by
 anArray.  The Array contains three elements: two Integers and a Boolean.
 Generates an error if any element of the Array is missing or is of the wrong
 class.

 The first element of the Array (an Integer between -1000 and 1000)
 specifies a minimum number of Characters in the result String (that is,
 the 'width' of the string).  If this element is positive, the resulting
 String is padded with blanks to the right of the receiver.  If this element
 is negative, the blanks are added to the left of the receiver.  If the
 value of this element is not large enough to completely represent the Float,
 a longer String will be generated.

 The second element of the Array (a positive Integer less than 1000)
 specifies the maximum number of digits to display to the right of the
 decimal point.  If the value of this element exceeds the number of digits
 required to completely specify the Float, only the required number of digits
 are actually displayed.  If the value of this element is insufficient to
 completely specify the Float, the value of the Float is rounded up or
 down before it is displayed.

 The third element of the Array (a Boolean) indicates whether or not to display
 the magnitude using exponential notation.  (The value true indicates
 exponential notation and false indicates decimal notation.)

 For example, the number 12.3456 displayed with two different format Arrays
 would appear as follows:

 Format          Output
 #(10 5 true)    ' 1.23456E1'
 #(10 2 false)   '12.34'"

^ self asFloat asStringUsingFormat: anArray
%

category: 'Formatting'
method: SmallFloat
asString

"Returns a String corresponding to the value of the receiver.  Where applicable,
 returns one of the following Strings: 'PlusInfinity', 'MinusInfinity',
 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'."

^ self asFloat asStringUsingFormat: #(1 7 true)
%

category: 'Instance Creation'
classmethod: SmallFloat
fromString: aString

"Returns an instance of Float or SmallDouble, constructed from aString.  The String
 must contain only Characters representing the object to be created, although
 leading and trailing blanks are permitted.

 If the string represents an exceptional float, it must contain one of the
 following strings, with leading and trailing blanks permitted: 'PlusInfinity',
 'MinusInfinity', 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or
 'MinusSignalingNaN'.

 If the string does not conform to the above rules, this method generates an
 error or returns a signaling NaN.

 If the string is larger than 8191 bytes, an error is generated."

^ Float fromString: aString
%

category: 'Arithmetic'
method: SmallFloat
negated

"Returns a Number that is the negation of the receiver."

^ 0.0 - self 
%

category: 'Accessing'
method: SmallFloat
sign

"Returns 1 if the receiver is greater than zero, -1 if the receiver is
 less than zero, and zero if the receiver is zero."

^ self asFloat sign
%

category: 'Converting'
method: SmallFloat
asDecimalFloat

"Returns a DecimalFloat representing the receiver."

^ self asFloat asDecimalFloat
%

category: 'Storing and Loading'
classmethod: SmallFloat
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

inst := (passiveObj upToSeparator) asFloat.
passiveObj hasRead: inst.
^inst
%

