!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: rcctrelem.gs,v 1.5 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   RcCounterElement, Object.
!
!=========================================================================

expectvalue %String
run
^ Object _newKernelSubclass: 'RcCounterElement'
  instVarNames: #(#value)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: Globals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false
  reservedOop: 847
%

removeallmethods RcCounterElement
removeallclassmethods RcCounterElement

category: 'For Documentation Installation only'
classmethod: RcCounterElement
installDocumentation

| doc |
doc := GsClassDocumentation _newForPrivateGsClass: self.

doc documentClassWith: (GsDocText new).

self description: doc.
%

! ------------------- Class methods for RcCounterElement
category: 'Instance Creation'
classmethod: RcCounterElement
new

"Creates and returns a new instance of the receiver."

^ self basicNew initialize
%

! ------------------- Instance methods for RcCounterElement
category: 'Updating'
method: RcCounterElement
decrementValueBy: aNumber

"Decrement the current value by the given amount."

value := value - aNumber
%

category: 'Updating'
method: RcCounterElement
incrementValueBy: aNumber

"Increments the current value by the given amount."

value := value + aNumber
%

category: 'Initialization'
method: RcCounterElement
initialize

"Initializes the value to be zero."

self value: 0
%

category: 'Accessing'
method: RcCounterElement
value

"Returns the value of the instance variable 'value'."

^ value
%

category: 'Updating'
method: RcCounterElement
value: newValue

"Modifies the value of the instance variable 'value'."

value := newValue
%

